; file      : 4X4_1-0.inc
; author    : 
; date      : 14-SEP-1999
; purpose   : 4 x 4 Keypad Input
; used by   : Library routine
;
; Copyright (C) Lascar Electronics Ltd 1999
;
; This library is free software; you can redistribute it and/or
; modify it under the terms of the GNU Lesser General Public
; License as published by the Free Software Foundation; either
; version 2.1 of the License, or (at your option) any later version.
;
; This library is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; Lesser General Public License for more details.

; You should have received a copy of the GNU Lesser General Public
; License along with this library; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
; USA
;
;**************************************************************

KY4x4	BCF	rb0	    		;bank0
	BCF	DIGIT2		;1st digit entry
	CLRF	portb			;clear portb O/P data latches
	CLRF	portd			;clear portd O/P data latches
	CLRF	porte			;clear porte O/P data latches
	BSF	rb0			;bank1
	MOVLW	b'00000000'		;porte (3 ports only)
	MOVWF	trise			;porte0,2outputs (bit4 sets PSP)	
	MOVLW	b'11110000'		;portd0,3inputs
	MOVWF	trisd			;portd4,7outputs
	BCF	rb0			;bank0
	BSF	porte,0		;Set 4x4 keyboard active led on
KYIN2	CLRF	ASCII			;reset ASCII value
	BSF	portd,0	   	;Keycol1 Hi
	CALL	RD_ROW		;Read 4x4 keyboard
	BCF	portd,0		;Keycol1 Lo
	BSF	portd,1		;Keycol2 Hi
	CALL	RD_ROW		;Read 4x4 keyboard
	BCF	portd,1		;Keycol2 Lo
	BSF	portd,2		;Keycol3 Hi
	CALL	RD_ROW		;Read 4x4 keyboard
	BCF	portd,2		;Keycol3 Lo
	BSF	portd,3		;Keycol4 Hi
	CALL	RD_ROW		;Read 4x4 keyboard
	BCF	portd,3		;Keycol4 Lo
	GOTO	KY4x4			;Keep reading keyboard
;
;If 1st digit (DIGIT2 flag clear) hold it in TEMP1 
;If 2nd digit (DIGIT2 flag set)   hold it in TEMP2
;
DIG_1	BSF	porte,1	    	;Set 1st digit LED
	BSF	DIGIT2		;set FLAG,3
	MOVF	ASCII,w	        ;w=1st digit
	MOVWF	TEMP1			;TEMP1=1st digit
	GOTO	KYIN2			;fetch 2nd digit			
PROCS	MOVLW	020H	   		;130mS contact-bounce and
	MOVWF	DS_DEL 		;key repeat delay value
	CALL	DELAY			;delay subroutine
	BTFSS	DIGIT2	   	;2nd digit?
	GOTO	DIG_1			;No? Then store digit1 in TEMP1
	BCF	porte,1		;Turn off 1st digit LED
	RLF	ASCII,f		;Yes? Then x2 and
	RLF	ASCII,f		;x4	
	RLF	ASCII,f		;x8
	ADDWF	ASCII,f		;x9
	ADDWF	ASCII,f		;x10
ADD_1	MOVF	TEMP1,w	   	;add 1st digit
	ADDWF	ASCII,f		;Full ASCII value
;
;Now check for BELL, BACKSPACE & ENTER
;
KEYCHECK		    	;Digit processing
;Check for BELL (07)
;
	MOVLW	07H			;
	SUBWF ASCII,w		;subtract 07H from ASCII
	BTFSC zero			;was input 07H?
	CALL	BELL			;Yes? 
;Check for BACKSPACE (08)	;No?
;
	MOVLW	08H			;
	SUBWF	ASCII,w		;subtract 08H from ASCII
	BTFSC	zero            	;was input 08H?
	DECF	fsr,f 		;Yes? Then overwrite previous digit!
;					;No? Then check for 'ENTER"
;Check for 'ENTER'...(AD)
;
	MOVLW 0ADH       		;
	SUBWF rcreg,w       	;subtract 0ADH from input byte
	BTFSC zero            	;was input 0ADH?
;	GOTO SCROLL_A		;Yes? Then start scrolling routine
	MOVF ASCII,w		;Ready to read EEPROM tables
	GOTO KYIN2			;No? Then goto main character
;					;input routine
;**************************************************************
RD_ROW	
	BTFSC	portd,4	    	;S18;Key x pressed?
	GOTO	PROCS			;M23a;Yes? Then
	INCF	ASCII,f		;No? Then DIGITS=2etc
	NOP				;TEST-set trisd=0
	NOP				;TEST-ser portd,5(20H)
	BTFSC	portd,5		;Key x pressed?
	GOTO	PROCS			;M23a;Yes? Then process digit
	INCF	ASCII,f		;No? Then DIGITS=3etc
	BTFSC	portd,6		;Key x pressed?
	GOTO	PROCS			;M23a;Yes? Then process digit
	INCF	ASCII,f		;No? Then DIGITS=4etc
	BTFSC	portd,7		;Key x pressed?
	GOTO	PROCS			;M23a;Yes? Then process digit
	RETURN			;
;**************************************************************
BELL	MOVLW	01H
	MOVWF	DS_DEL
	BSF	rb0	    		;bank1
	MOVLW	b'00000011'		;common configuration for
	MOVWF	adcon1		;porte digital and
	MOVWF	trise			;CS as output
	BCF	rb0			;bank0
BELL1	MOVLW	09AH
	MOVWF	TEMP1
BELL2	BSF	CS			;porte,2 Hi		
	CALL	DELAY
	BCF	CS			;porte,2 Lo	
	CALL	DELAY
	DECFSZ	TEMP1,f
	GOTO	BELL2
	MOVLW	01H
	ADDWF	DS_DEL,f
	GOTO	BELL1
;**************************************************************
