; file      : cntr_1-0.h
; author    : 
; date      : 14-SEP-1999
; purpose   : Determines the functionality of a counter.
; used by   : Library routine
;
; Copyright (C) Lascar Electronics Ltd 1999
;
; This library is free software; you can redistribute it and/or
; modify it under the terms of the GNU Lesser General Public
; License as published by the Free Software Foundation; either
; version 2.1 of the License, or (at your option) any later version.
;
; This library is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; Lesser General Public License for more details.

; You should have received a copy of the GNU Lesser General Public
; License along with this library; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
; USA
;
;**************************************************************
;
;
;EDITING THIS FILE allows the user to alter the funtionality of the LASCAR MDM-1 display
;module.  The digit order is 5 4 3 2 1..
;
;	       DIGIT
;	      POSITION
;*************************************************************************************
CU1	equ  0   ;1	;UP-OFFSET:-
CU2   	equ  0   ;2     ;To start the counter counting up 
CU3   	equ  0   ;3	;from some other count than zero 	
CU4   	equ  0   ;4	;change these numbers 00000 
CU5   	equ  0	 ;5	;to the required count
;*************************************************************************************
CUA1	equ  4   ;1	;UP (HI) -ALARM LEVEL:-
CUA2   	equ  2   ;2     ;To set the alarm to 
CUA3   	equ  0   ;3	;some other count than 00025 	
CUA4   	equ  0   ;4	;change these numbers 00024 
CUA5   	equ  0	 ;5	;to the required level
;*************************************************************************************
CUW1	equ  9   ;1	;UP (HI) -WARNING LEVEL:-
CUW2   	equ  1   ;2     ;To set the alarm to 
CUW3   	equ  0   ;3	;some other count than 00020 	
CUW4   	equ  0   ;4	;change these numbers 00019 
CUW5   	equ  0	 ;5	;to the required level
;***********************************************************************
CD1   	equ  9   ;1	;DOWN-OFFSET:-
CD2   	equ  9   ;2     ;To start the counter counting down 
CD3   	equ  9   ;3 	;from some other count than 99999 	
CD4   	equ  9   ;4	;change these numbers 99999
CD5   	equ  9	 ;5	;to the required count
;*************************************************************************************
CDA1	equ  6   ;1	;DOWN (LO) -ALARM LEVEL:-
CDA2   	equ  7   ;2     ;To set the alarm to 
CDA3   	equ  9   ;3	;some other count than 99975 	
CDA4   	equ  9   ;4	;change these numbers 99976 
CDA5   	equ  9	 ;5	;to the required level
;*************************************************************************************
CDW1	equ  1   ;1	;DOWN (LO) -WARNING LEVEL:-
CDW2   	equ  8   ;2     ;To set the alarm to 
CDW3   	equ  9   ;3	;some other count than 99980 	
CDW4   	equ  9   ;4	;change these numbers 99981 
CDW5   	equ  9	 ;5	;to the required level
;***********************************************************************
SBC   	equ  0		;Anti-bounce timer - set between 5 and 20
;			;6=1mS; 20=130mS (cubic function!)
;			;Set to '0' for anti-bounce OFF.
;*************************************************************************************
;***The following variables are unimplemented at this stage***

ZSC   	equ  0   	;Zero suppression is off...
;			;Set this value to 1 for leading zero suppression.
;
IOC   	equ  0		;Input increments/decrements on a switch closure
;			;Change to a '1' for switch opening.
;				
;
;*************************************************************************************	

