; file      : cntr_1-0.inc
; author    : 
; date      : 14-SEP-1999
; purpose   : Counter module
; used by   : Library routine
;
; Copyright (C) Lascar Electronics Ltd 1999
;
; This library is free software; you can redistribute it and/or
; modify it under the terms of the GNU Lesser General Public
; License as published by the Free Software Foundation; either
; version 2.1 of the License, or (at your option) any later version.
;
; This library is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; Lesser General Public License for more details.

; You should have received a copy of the GNU Lesser General Public
; License along with this library; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
; USA
;
;**************************************************************

;***DISPLAY COUNT MESSAGE***
COUNT_PROG
	CALL	CLR_DISPS2
	BCF	rb0		;set
	BSF	rb1		;bank2
	MOVLW	1EH		;w=vector for COUNT
	MOVWF	EEP2		;EEP2 = COUNT
	CALL	READ_MESSB	;Display message

;***WRITE CONFIGURATION VALUE TO EEPROM***
;For counter the value 02h is written to address 0ffh

	BCF	rb0			;set
	BSF	rb1			;bank2
	MOVLW	0FFH			;W=0FFH 
	MOVWF	eeadr			;eeardr=0FFH
	MOVLW	02H			;W=02H
	MOVWF	eedata			;eedata=02H
	BSF	rp2			;page3
	CALL	WR_EEPROM		;read from EEPROM
	BCF	rp2			;page2	
	
;***SET UP PORTS FOR THE COUNTER ROUTINE***

CNTRA	CLRF	porta		;Clear
	CLRF	portb		;ports
	CLRF	portc		;
	CLRF	portd		;
	CLRF	porte		;
	BSF	rb0		;bank1
	MOVLW	b'10000110'	;bit configuration to
	MOVWF	adcon1		;set porta digital 
	MOVLW	b'11111111' 	;Set inputs
	MOVWF	trisa		;on porta
	MOVLW	b'00000000' 	;Set outputs for warning
	MOVWF	trisb		;and alarm messages on portb
	MOVLW	b'11111111'	;Set intputs
	MOVWF	trisc		;on portc
	MOVLW	b'11111111'	;Set intputs
	MOVWF	trisd		;on portd
	MOVLW	07H		;Set intputs
	MOVWF	trise		;on porte
	CLRF	status		;bank0
RST	BCF	FLAG2,3		;near overflow flag
	CLRF	ACC1		;Clear
	CLRF	ACC2		;
	CLRF	ACC3		;
	CLRF	portb		;Clear all alm/warning messages on reset

;***COUNT UP OR DOWN?***

	BTFSS	portd,1		;Count Up or Down?
	GOTO	SET_UP		;set initial numbers for count up
	GOTO	SET_DOWN	;set initial numbers for count down

SET_UP	MOVLW	CU5		;value from header file
	MOVWF	BCD5		;into BCD5
	MOVLW	CU4		;value from header file
	MOVWF	BCD4		;into BCD4
	MOVLW	CU3		;value from header file
	MOVWF	BCD3		;into BCD3
	MOVLW	CU2		;value from header file
	MOVWF	BCD2		;into BCD2
	MOVLW	CU1		;value from header file
	MOVWF	BCD1		;into BCD1
	BSF	rp2		;page3
	CALL	BCD_BINARY
	BCF	rp2		;page2	
	GOTO	DISPLAY_CNTR	;display
SET_DOWN
	MOVLW	CD5		;value from header file
	MOVWF	BCD5		;into BCD5
	MOVLW	CD4		;value from header file
	MOVWF	BCD4		;into BCD4
	MOVLW	CD3		;value from header file
	MOVWF	BCD3		;into BCD3
	MOVLW	CD2		;value from header file
	MOVWF	BCD2		;into BCD2
	MOVLW	CD1		;value from header file
	MOVWF	BCD1		;into BCD1
	BSF	rp2		;page3
	CALL	BCD_BINARY
	BCF	rp2		;page2	
	GOTO	DISPLAY_CNTR	;display

;***MAIN COUNTER PROGRAM STARTS HERE***

LOW_LOOP
	BTFSC	porta,4		;Is the counter input high?
	GOTO	LOW_LOOP	;Yes? Then wait for the next low
	GOTO	CNTR2		;No? Then wait for next count

CNTR1	BSF	rp2		;page3	
	CALL	LED_OFF		;Program active indicator
	BCF	rp2		;page2
CNTR2	BTFSC	porta,4		;Is the counter input high?
	GOTO	CNTR3		;Yes? Then count one...
	GOTO	CNTR2		;No? Then wait for next count
CNTR3	BSF	rp2		;page3
	CALL	LED_ON		;Yes? Program active indicator
	MOVLW	SBC		;Set switch anti-bounce value
	MOVFW	DS_DEL		;set delay time with this value
	CALL	DELAY		;and wait (for bounce to stop?)
	BCF	rp2		;page2
	BTFSC	portd,1		;Count Up or Down?
	GOTO	CNTDN		;portd,1 Hi? Then count down...

;***ROUTINE FOR COUNTING UP***

;1st check for overflow
CNTUP	MOVLW	09H		;
	SUBWF	BCD5,w		;
	BTFSS	zero		;BCD5-09H=0?
	GOTO	CNTUP1		;
	MOVLW	09H		;value from header
	SUBWF	BCD4,w		;
	BTFSS	zero		;BCD5-09H=0?
	GOTO	CNTUP1		;
	MOVLW	09H		;value from header
	SUBWF	BCD3,w		;
	BTFSS	zero		;BCD5-09H=0?
	GOTO	CNTUP1		;
	MOVLW	09H		;value from header
	SUBWF	BCD2,w		;
	BTFSS	zero		;BCD5-09H=0?
	GOTO	CNTUP1		;
	MOVLW	09H		;value from header
	SUBWF	BCD1,w		;
	BTFSC	zero		;BCD5-09H=0?
	GOTO	RST		;reset counter for up
;start counting up
CNTUP1	INCFSZ	ACC1,f		;Start counting up
	GOTO	ALM_UP		;loop...
	INCFSZ	ACC2,f		;ACC2+1
	GOTO	ALM_UP		;loop...
	INCF	ACC3,f		;ACC3+1
	GOTO	ALM_UP		;No, loop...

;***ROUTINE FOR COUNTING DOWN***

;1st check for underflow
CNTDN	BTFSC	FLAG2,3		;reset?
	GOTO	RST		;reset?
	MOVLW	00H		;
	SUBWF	BCD5,w		;
	BTFSS	zero		;BCD5-00H=0?
	GOTO	CNTDN1		;
	MOVLW	00H		;value from header
	SUBWF	BCD4,w		;
	BTFSS	zero		;BCD5-00H=0?
	GOTO	CNTDN1		;
	MOVLW	00H		;value from header
	SUBWF	BCD3,w		;
	BTFSS	zero		;BCD5-00H=0?
	GOTO	CNTDN1		;
	MOVLW	00H		;value from header
	SUBWF	BCD2,w		;
	BTFSS	zero		;BCD5-00H=0?
	GOTO	CNTDN1		;
	MOVLW	01H		;value from header
	SUBWF	BCD1,w		;
	BTFSC	zero		;BCD5-00H=0?
	BSF	FLAG2,3		;set near overflow flag
;start counting down
CNTDN1	DECFSZ	ACC1,f		;Start counting down...
	GOTO	ALM_DOWN	;loop...
	BTFSC	FLAG2,3		;near overflow?
	GOTO	ALM_DOWN	;Yes, ...
	DECFSZ	ACC2,f		;ACC2-1
	GOTO	ALM_DOWN	;loop...
	DECF	ACC3,f		;ACC3-1
	GOTO	ALM_DOWN	;No, loop...

;***CHECK FOR ALARM LEVELS***

ALM_UP
	MOVLW	CUA5		;value from header
	SUBWF	BCD5,w		;
	BTFSS	zero		;BCD5-CUA5=0?
	GOTO	WARN_UP		;
	MOVLW	CUA4		;value from header
	SUBWF	BCD4,w		;
	BTFSS	zero		;BCD5-CUA4=0?
	GOTO	WARN_UP		;
	MOVLW	CUA3		;value from header
	SUBWF	BCD3,w		;
	BTFSS	zero		;BCD5-CUA3=0?
	GOTO	WARN_UP		;
	MOVLW	CUA2		;value from header
	SUBWF	BCD2,w		;
	BTFSS	zero		;BCD5-CUA2=0?
	GOTO	WARN_UP		;
	MOVLW	CUA1		;value from header
	SUBWF	BCD1,w		;
	BTFSS	zero		;BCD5-CUA1=0?
	GOTO	WARN_UP		;
	CALL	HI_ALM2		;do hi alarm
	GOTO	DISPLAY_CNTR
WARN_UP
	MOVLW	CUW5		;value from header
	SUBWF	BCD5,w		;
	BTFSS	zero		;BCD5-CUW5=0?
	GOTO	DISPLAY_CNTR	;
	MOVLW	CUW4		;value from header
	SUBWF	BCD4,w		;
	BTFSS	zero		;BCD5-CUW4=0?
	GOTO	DISPLAY_CNTR	;
	MOVLW	CUW3		;value from header
	SUBWF	BCD3,w		;
	BTFSS	zero		;BCD5-CUW3=0?
	GOTO	DISPLAY_CNTR	;
	MOVLW	CUW2		;value from header
	SUBWF	BCD2,w		;
	BTFSS	zero		;BCD5-CUW2=0?
	GOTO	DISPLAY_CNTR	;
	MOVLW	CUW1		;value from header
	SUBWF	BCD1,w		;
	BTFSS	zero		;BCD5-CUW1=0?
	GOTO	DISPLAY_CNTR	;
	CALL	TOO_HI2		;do hi warning
	GOTO	DISPLAY_CNTR

ALM_DOWN
	MOVLW	CDA5		;value from header
	SUBWF	BCD5,w		;
	BTFSS	zero		;BCD5-CDA5=0?
	GOTO	WARN_DOWN	;
	MOVLW	CDA4		;value from header
	SUBWF	BCD4,w		;
	BTFSS	zero		;BCD5-CDA4=0?
	GOTO	WARN_DOWN	;
	MOVLW	CDA3		;value from header
	SUBWF	BCD3,w		;
	BTFSS	zero		;BCD5-CDA3=0?
	GOTO	WARN_DOWN	;
	MOVLW	CDA2		;value from header
	SUBWF	BCD2,w		;
	BTFSS	zero		;BCD5-CDA2=0?
	GOTO	WARN_DOWN	;
	MOVLW	CDA1		;value from header
	SUBWF	BCD1,w		;
	BTFSS	zero		;BCD5-CDA1=0?
	GOTO	WARN_DOWN	;
	CALL	LO_ALM2		;do lo alarm
	GOTO	DISPLAY_CNTR
WARN_DOWN
	MOVLW	CDW5		;value from header
	SUBWF	BCD5,w		;
	BTFSS	zero		;BCD5-CDW5=0?
	GOTO	DISPLAY_CNTR	;
	MOVLW	CDW4		;value from header
	SUBWF	BCD4,w		;
	BTFSS	zero		;BCD5-CDW4=0?
	GOTO	DISPLAY_CNTR	;
	MOVLW	CDW3		;value from header
	SUBWF	BCD3,w		;
	BTFSS	zero		;BCD5-CDW3=0?
	GOTO	DISPLAY_CNTR	;
	MOVLW	CDW2		;value from header
	SUBWF	BCD2,w		;
	BTFSS	zero		;BCD5-CDW2=0?
	GOTO	DISPLAY_CNTR	;
	MOVLW	CDW1		;value from header
	SUBWF	BCD1,w		;
	BTFSS	zero		;BCD5-CDW1=0?
	GOTO	DISPLAY_CNTR	;
	CALL	TOO_LO2		;do lo warning

;***DISPLAY RESULTS***

DISPLAY_CNTR
	BSF	rp2		;page3
	CALL	BINARY_BCD
	NOP
	CALL 	NUM_SEGS	;Fetch display segments 'A'
	CLRF	SHIFTX		;COM1
	CALL	ASSEMBLE	;Assemble 43 bit 'A' word
	BSF	B_SEGS		;set LUT 'B' flag
	CALL 	NUM_SEGS	;Fetch display segments 'B'
	MOVLW	020H		;COM2
	MOVWF	SHIFTX		;bit
	CALL	ASSEMBLE	;Assemble 43 bit 'B' word
	BCF	rp2		;page2

	BTFSS	portd,0		;reset button pressed?
	GOTO	LOW_LOOP
	GOTO	RST
	
;**************************************************************
