; file      : defn_1-1.h
; author    : 
; date      : 30-AUG-2002
; purpose   : register Definition
; used by   : mdm_1-2.asm
;
; Copyright (C) Lascar Electronics Ltd 2002
;
; This library is free software; you can redistribute it and/or
; modify it under the terms of the GNU Lesser General Public
; License as published by the Free Software Foundation; either
; version 2.1 of the License, or (at your option) any later version.
;
; This library is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; Lesser General Public License for more details.

; You should have received a copy of the GNU Lesser General Public
; License along with this library; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
; USA
;
;**************************************************************


; This header file contains the register definitions (labels) selected by
; Lascar's Engineers to assist the user in understanding of the Software Code.

; These labels may be changed by the user but any dependant files may also have to be 
; changed.
;
;30/08/2002 ACC4 definition added - Used by Maths multiply.  WARNING DUPLICATE DPM EQU
;
;***BIT DEFINITIONS***
#define	rcif	pir1,5
#define carry   status,0        ;Register overflow
#define digcar  status,1        ;Mid-register hop
#define zero    status,2        ;Zero flag
#define rb0     status,5        ;Bank0/1 select bit
#define rb1     status,6        ;Bank2/3 select bit
#define rp2	pclath,3	;Page0/1 select bit
#define	rp3	pclath,4	;Page2/3 select bit
#define irp     status,7        ;Indirect register bank0/3 select bit
#define intf    intcon,1        ;RB0/INT external interrupt flag
#define inte    intcon,4        ;RB0/INT external interrupt enable
#define peie    intcon,6        ;Peripheral interrupt enable
#define gie     intcon,7        ;Global interrupt enable
#define BLANK   FLAG1,0          ;Display blanking flag
#define	LUT_FLG	FLAG1,1		;Look-up table finished bit
#define	B_SEGS	FLAG1,2		;Look-up table 'B' segments
#define	DIGIT2	FLAG1,3		;1st/2nd digit flag
#define	TST_DLY	FLAG1,4		;Short delay for test purposes
#define	NEGF1	FLAG1,5		;1st No. negative flag
#define NEGF2	FLAG1,6		;2nd No. negative flag
#define C_FLG	FLAG1,7		;carry holding bit
#define BINOF	FLAG2,0		;Binary register overflow
#define	O_UFLW	FLAG2,1		;Over/underflow flag	
;
;***I/O DEFINITIONS***
#define A_D1    porta,1         ;MDM-1 I/O definitions
#define A_D2    porta,3		;as per LASCAR 
#define A_D3    porta,5		;data sheet...
#define RD      porte,0
#define WR      porte,1
#define CS      porte,2
#define PI_O0   portd,0
#define PI_O1   portd,1
#define PI_O2   portd,2
#define PI_O3   portd,3
#define PI_O4   portd,4
#define PI_O5   portd,5
#define PI_O6   portd,6
#define PI_O7   portd,7
#define I_1     portb,0
#define INT     portb,1
#define PWM1    portc,1
#define PWM2    portc,2
#define TIMER1  porta,4
#define TIMER2  porta,0
#define RS232Rx portc,7
#define RS232Tx portc,6
#define SDO     portc,5
#define ICSDA   portc,4
#define ICSCK   portc,3
;Note:-The next three 'b' ports are NOT available
;      for external user usage...
#define LOAD    portb,2 ;Load display driver 
#define DATA    portb,4 ;Data for display driver 
#define CLOCK   portb,5 ;Display driver clock 
;
;***SIX 5-DIGIT DISPLAY DRIVER REGISTERS***
SHIFT5  EQU     20H     ;LCD driver 6 byte
SHIFT4  EQU     21H     ;5 digit display
SHIFT3  EQU     22H     ;shift register of 48bits,
SHIFT2  EQU     23H     ;of which 43 are used
SHIFT1  EQU     24H     ;and SHIFTX which
SHIFTX  EQU     25H     ;defines COM1 or COM2
;****PRIMARY MATHEMATICS REGISTERS********************
BCD1	EQU	26H	;BCD register 1 (LSByte)
BCD2	EQU	27H	;BCD register 2
BCD3	EQU	28H	;BCD register 3
BCD4	EQU	29H	;BCD register 4
BCD5	EQU	2AH	;BCD register 5 (MSByte)
ACC1	EQU	2BH	;accumulator Lo byte
ACC2	EQU	2CH	;accumulator 2nd byte
ACC3	EQU	2DH	;accumulator
ACC4	EQU	2EH	;accumulator Hi byte ** WARNING DUPLICATE DPM EQU
;***DISPLAY DATA REGISTERS***
EEP1	EQU	120H	;EEPROM pointer 1
EEP2	EQU	121H	;EEPROM pointer 2
EEP3	EQU	122H	;EEPROM pointer 3
EEP4	EQU	123H	;EEPROM pointer 4
SP1	EQU	5DH	;*Scroll pointer 1
SP2	EQU	5EH	;*Scroll pointer 2
DPM	EQU	2EH	;Digit position modifier
DIGADR	EQU	2FH	;Message register starting address
;Repeat addresses-
DISP5   EQU     30H     ;*Display digit 5
DISP4   EQU     31H     ;*
DISP3   EQU     32H     ;*
DISP2   EQU     33H     ;*
DISP1   EQU     34H     ;*Display digit 1
DIG6    EQU     35H	;*Scrolling digit6
DIG7    EQU     36H	;*
DIG8    EQU     37H	;*
DIG9    EQU     38H	;*
DIG10   EQU     39H     ;*
DIG11   EQU     3AH     ;*
DIG12   EQU     3BH     ;*
DIG13   EQU     3CH	;*
DIG14   EQU     3DH	;*
DIG15   EQU     3EH	;*
DIG16   EQU     3FH	;*
DIG17   EQU     40H	;*
DIG18   EQU     41H	;*
DIG19   EQU     42H	;*
DIG20   EQU     43H	;*
DIG21   EQU     44H	;*
DIG22   EQU     45H	;*
DIG23   EQU     46H	;*
DIG24   EQU     47H	;*
DIG25   EQU     48H	;*Scrolling digit25
DIG26	EQU	49H	;
DIG27	EQU	4AH	;
DIG28	EQU 	4BH	;
DIG29	EQU  	4CH	;
DIG30	EQU	4DH	;
DIG31	EQU	4CH	;
DIG32	EQU	4DH	;
DIG33	EQU	4EH	;
;***GENERAL PURPOSE REGISTERS***
BITS    EQU     49H     ;Number of bits counter
DIGITS  EQU     4AH     ;Number of digits counter
W_SAVE  EQU     4BH     ;Save w register
S_SAVE  EQU     4CH     ;Save status register
P_SAVE  EQU     4DH     ;Save pclath register
FSR_S	EQU	4EH	;Save file select register
FLAG1   EQU     4FH     ;General purpose flags.1
FLAG2  	EQU	50H	;General purpose flags.2
DS_DEL 	EQU     51H     ;Display delay value
ASCII	EQU	53H	;ASCII 	value
TEMP1   EQU     54H     ;Temporary counter 1
TEMP2   EQU     55H     ;Temporary counter 2
TEMP3	EQU	56H	;Temporary counter 3
TEMP4	EQU	57H	;Temporary counter 4
PTR1	EQU	58H	;Pointer1 initialise
PTR2	EQU	59H	;Pointer2 initialise
ITER1	EQU	5AH	;Iteration counter 1
ITER2	EQU	5BH	;Iteration counter 2
ITER3	EQU	5CH	;Iteration counter 3
;***MATHEMATICS REGISTERS 1 (On Repeat Addresses)***
ADD1L	EQU	30H	;*Addition Lo byte1
ADD1H	EQU	31H	;*Addition Hi byte1
ADD2L	EQU	32H	;*Addition Lo byte2
ADD2H	EQU	33H	;*Addition Hi byte2
MPLRL  	EQU	34H	;*multiplier Lo byte
MPLRH  	EQU	35H	;*multiplier Hi byte
MCNDL  	EQU	36H	;*multiplicand Lo byte
MCNDH	EQU	37H	;*multiplicand Hi byte
CREGL  	EQU	38H	;*Lo carry reg
CREGH  	EQU	39H	;*Hi carry reg
PP1	EQU	3AH	;*partial product Lo byte
PP2	EQU	3BH	;*partial product 2nd byte
PP3	EQU	3CH	;*partial product Hi byte
;***MATHEMATICS REGISTERS 2 (On Repeat Addresses)
SUB1L	EQU	30H	;*Subtraction Lo byte1
SUB1H	EQU	31H	;*Subtraction Hi byte1
SUB2L	EQU	32H	;*Subtraction Lo byte2
SUB2H	EQU	33H	;*Subtraction Hi byte2
DVD1	EQU	34H	;*Dividend Lo byte
DVD2	EQU	35H	;*Dividend 2nd byte
DVD3	EQU	36H	;*Dividend Hi byte
PD1	EQU	37H	;*partial dividend Lo byte
PD2	EQU	38H	;*partial dividend 2nd byte
PD3	EQU	39H	;*partial dividend Hi byte
DVRL	EQU	3AH	;*Divisor Lo byte
DVRH	EQU	3BH	;*Divisor Hi byte
DVR1	EQU	3CH	;*Divisor operational Lo byte
DVR2	EQU	3DH	;*Divisor operational 2nd byte
DVR3	EQU	3EH	;*Divisor operational Hi byte
REM1	EQU	3FH	;*remainder Lo byte
REM2	EQU	40H	;*remainder 2nd byte
REM3	EQU	41H	;*remainder Hi byte
DCR1	EQU	42H	;*Divide counter Lo byte
DCR2	EQU	43H	;*Divide counter 2nd byte
DCR3	EQU	44H	;*Divide counter Hi byte
;
;***USER VACANT REGISTERS***
;5FH to 7FH in this bank0...
;*=REPEAT ADDRESSES!!!-TAKE CARE!!!-
;
;*******************************************************
