; file      : efwr_1-0.inc
; author    : 
; date      : 14-SEP-1999
; purpose   : EEPROM & FLASH READ/WRITE MANAGEMENT ROUTINES
; used by   : Library routine
;
; Copyright (C) Lascar Electronics Ltd 1999
;
; This library is free software; you can redistribute it and/or
; modify it under the terms of the GNU Lesser General Public
; License as published by the Free Software Foundation; either
; version 2.1 of the License, or (at your option) any later version.
;
; This library is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; Lesser General Public License for more details.

; You should have received a copy of the GNU Lesser General Public
; License along with this library; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
; USA
;
;**************************************************************
;
; This routines as used to address and read/write the E2PROM data memory or 
; the Flash program memory area during operation of the 16F877 PICmicro (R)
; using the definitions and addresses found in Lascar's two header files 
; (SFR and DEFN)
;


; **Read E2PROM**

; This routine read the data at the address set in the "eeadr" SFR
; and places it in the SFR "eedata"

RD_EEPROM		     ;S1;EEPROM address (eeadr)
				;must have been
				;selected in the calling program. 
	BSF	rb0		;Set
        BSF     rb1             ;bank3
        BCF     eecon1,7        ;point to data memory (eepgd=0)
        BSF     eecon1,0        ;EEPROM read (rd)
	BCF	rb0		;bank2 for return read
	RETURN

; ** Write E2PROM**
;
; This routine takes the data placed in eedata by the calling routine and 
; places it in the memory location pointed to by eeadr (also set by calling 
; routine.

WR_EEPROM		     ;S2;EEPROM address (eeadr) and
				;value (eedata) must have been
				;selected in the calling program.
	BCF	rb1		;bank0
	BCF	pir2,4		;Clear eeif
	BSF	rb0		;Set
        BSF     rb1             ;bank3
        BCF     eecon1,7        ;point to data memory (eepgd=0)
        BSF     eecon1,2        ;enable write (wren=1)
        BCF     gie             ;disable interrupts
        MOVLW   55H             ;Mandatory write
        MOVWF   eecon2          ;instruction
        MOVLW   0AAH            ;sequence
        MOVWF   eecon2          ;for PIC16F877
        BSF     eecon1,1        ;Set wr bit to begin write (wr)         
        BCF     eecon1,2        ;Disable write program. (wren=0)
	CLRF	status		;bank0
EEIF_S	BTFSS	pir2,4	    ;S2a;eeif set?
	GOTO	EEIF_S		;try again
	BSF	rb0		;Set
	BSF	rb1		;bank3
	BCF	eecon1,2	;Disable write (wren=0)
	CLRF	status		;exit in bank0
        BSF     gie             ;Enable interrupts		
	RETURN

; **Read FLASH**
;
;This routine uses the eeadr and eeadh registers to address program 
; memory. The data at that address is returned in the eedata and eedath
; registers. The address you wish to read must be set by the calling routine
; It should be noted that both address registers must be used.

RD_FLASH		     ;S3;EEPROM address (eeadr/h) and
				;value (eedata/h) must have been
				;selected in the calling program. 
	BSF	rb0		;Set       
        BSF     rb1             ;bank3
        BSF     eecon1,7        ;point to program memory (eepgd=1)
        BSF     eecon1,0        ;read EEPROM (rd)
        NOP                     ;Read sequence
        NOP                     ;complete
        BCF     rb0             ;bank2
        MOVF    eedata,w        ;w=LSByte of program eedata
	BCF	rb0		;Set       
        BCF     rb1             ;bank0
	RETURN

; ** Write FLASH**

; This routine will take the data set in registers eedat and eedath
; and write them into the program memory address set by eeadr and eeadh
; in the calling routine during run time.
; BEWARE it is possible to overwrite program memory which is already being
; used by your program making your application unstable.
; we recommend that if you wish to use program memory for data storage you reserve 
; an area for that purpose well away from your other programs.

WR_FLASH			;EEPROM address (eeadr/h) and
				;value (eedata/h) must have been
				;selected in the calling program
	BSF	rb0		;set
	BSF	rb1		;bank3
	BSF	eecon1,7	;point to program memory (eepgd=1)
	BSF	eecon1,2	;enable write sequence (wren=1)
	BCF	gie		;disable interupts
	MOVLW	55H		;Mandatory write
	MOVWF	eecon2		;instruction sequence
	MOVLW	0AAH		;sequence
	MOVWF	eecon2		;for pic16f877
	BSF	eecon1,1	;set wr bit for write sequence
	NOP			;write sequence
	NOP			;complete
	BSF	gie		;Enable interupts
	BCF	eecon1,2	;Disable write program (wren=0)
	CLRF	status		;return in bank 0
	RETURN
