; file      : ltdd_1-0.inc
; author    : 
; date      : 14-SEP-1999
; purpose   : Display driver
; used by   : Library routine
;
; Copyright (C) Lascar Electronics Ltd 1999
;
; This library is free software; you can redistribute it and/or
; modify it under the terms of the GNU Lesser General Public
; License as published by the Free Software Foundation; either
; version 2.1 of the License, or (at your option) any later version.
;
; This library is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; Lesser General Public License for more details.

; You should have received a copy of the GNU Lesser General Public
; License along with this library; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
; USA
;
;**************************************************************
;
;DISP5 address=30H	DIG5A address=30H	SHIFT5 address=20H
;DISP4 address=31H	DIG5B address=35H	SHIFT4 address=21H
;DISP3 address=32H	DIG5C address=3AH	SHIFT3 address=22H
;DISP2 address=33H	DIG5D address=3FH	SHIFT2 address=23H
;DISP1 address=34H				SHIFT1 address=24H
;DIG25 address=48H				SHIFTX address=25H 	 
;
;DIG_ASA = Set address of first character in the group of five.
;DPM = Digit position modifier to shift display 1\2 positions to the right.	
;
;***CONVERT ASCII DIGITS TO DISPLAY SEGMENTS***...
;
ASL_B	CALL	LUT_B		;Fetch 'B' display segments
	GOTO	ASL2		;and implement
ASC_SEGS
	MOVF	DIGADR,w	;Address of DIG1n
	MOVWF	PTR1		;Load DIG pointer
	MOVLW	020H		;Address of SHIFT5
	MOVWF	PTR2		;Load SHIFT pointer
ASL1	MOVF	PTR1,w		;w=PTR1
	MOVWF	fsr		;fsr=PTR1=DIGnn address
	MOVF	indf,w	   	;get contents of DIGnn
	MOVWF	ASCII		;and hold in ASCII
	MOVLW	020H		;LUT offset
	SUBWF	ASCII,w		;ASCII-20H
	BTFSC	B_SEGS		;Is B flag set
	GOTO	ASL_B		;Yes? Then LUT numbers offset=+28H
	CALL	LUT_A		;Fetch 'A' segments
ASL2	MOVWF	TEMP1		;Hold segment data in TEMP1
	MOVF	PTR2,w		;Restore SHIFT address
	MOVWF	fsr		;fsr=PTR2=SHIFT address
	MOVF	TEMP1,w		;restore segment
	MOVWF	indf		;move data into SHIFTn
	INCF	PTR1,f	   	;point to next DIG register
	INCF	PTR2,f	   	;point to next SHIFT register	
	MOVLW	025H		;address of SHIFT1+1
	SUBWF	PTR2,w		;subtract from fsr
	BTFSS	zero		;Finished?
	GOTO	ASL1        	;No? Then loop
	BCF	B_SEGS		;Clear 'B' segments flag
	RETURN

;This subroutine should be called twice:- 
;To fetch the 'A' segments for COM1
;To fetch the 'B' segments for COM2
;
;The first 5 'B' DIGits have now been transferred to SHIFT 'B' registers.
;The main program should now call the ASSEMBLE routine to build a 43 bit COM2 string 
;to feed the LCD  via portb,4,5.  
;
;***CONVERT BCD NUMERALS TO DISPLAY SEGMENTS (direct)***...
;
TAB_B	CALL	LUT_B		;Fetch 'B' display segments
	GOTO	NUMS2		;and implement
;
;Direct access to the LUT tables...
NUM_SEGS
	MOVLW	026H		;Address of BCD1
	MOVWF	PTR1		;hold in pointer1
	MOVLW	024H		;Address of SHIFT1
	MOVWF	PTR2		;hold in pointer2
	MOVF	DPM,w		;Get digit position modifier
	SUBWF	PTR2,f		;modify SHIFT pointer
NUMS1	MOVF	PTR1,w		;w=BCD pointer
	MOVWF	fsr		;point to BCDn
	MOVF	indf,w		;get contents of BCDn
	MOVWF	TEMP3		;and hold in TEMP1
	MOVLW	010H		;No? Then LUT_A offset
	ADDWF	TEMP3,w		;add to value in BCD1
	BTFSC	B_SEGS		;Is 'B' flag set for LUT'B'?
	GOTO	TAB_B		;Yes?
	CALL	LUT_A		;Get 'A; display segments
NUMS2	MOVWF	TEMP4		;hold in TEMP2
	MOVF	PTR2,w		;Restore SHIFT address
	MOVWF	fsr		;file select register points to SHIFTn
	MOVF	TEMP4,w		;Restore value from BCDn
	MOVWF	indf		;put display segments into SHIFT
	INCF	PTR1,f	   	;point to next BCD register
	DECF	PTR2,f	   	;point to next SHIFT register	
	MOVLW	01FH		;address of SHIFT5+1
	SUBWF	PTR2,w		;subtract from fsr
	BTFSS	zero		;Finished?
	GOTO	NUMS1        	;No? Then loop
	BCF	B_SEGS		;Clear 'B' segments flag
	RETURN
;This subroutine should be called twice:- 
;To fetch the 'A' segments for COM1
;To fetch the 'B' segments for COM2
;
;The first 5 numerals have now been transferred to SHIFT 'B' registers.
;The main program should now call the ASSEMBLE routine to build a 43 bit COM2 string 
;to feed the LCD  via portb,4,5. 
;
;**************************************************************************
;
;***MDM-1 DISPLAY DRIVER SUBROUTINES***
;
;Load Display Driver routine...
;
;LCD Driver accepts two data blocks A&B of 42 bits 
;corresponding to 42 segments, 5 digits. A 43rd bit 
;sets which block is Lo-COM1/Hi-COM2
;These data blocks are held in the SHIFT registers 1 to 5
;SHIFTX holds the 43rd COM bit.
;
;LOAD,DATA & CLOCK use Portb,2,4,5 respectively
;These ports are not available for user use.
;
;***ASSEMBLE 43BIT WORD LCD DRIVER routine***
;
ASSEMBLE                     	;       
        BSF     rb0             ;Bank 1
        BCF     rb1             ;selected
        MOVLW   b'00000000'     ;set up portb O/Ps
        MOVWF   trisb           ;write port tris reg
        BCF     rb0             ;Back to bank 0
       	BCF	DATA
	BCF	CLOCK
	BCF	LOAD
        BCF     carry           ;clear carry bit
        MOVLW   .43             ;Ready to shift 43 bits (2BH)
        MOVWF   BITS            ;use 'BITS' to hold 43 bits
ASMBL1  BCF     carry       	;Clear carry flag 
        RLF     SHIFTX,f        ;and carry is 1 or 0 
        RLF     SHIFT5,f        ;Shift register into
        RLF     SHIFT4,f        ;lcd display driver
        RLF     SHIFT3,f        ;generating the necessary
        RLF     SHIFT2,f        ;clock and data bits
        RLF     SHIFT1,f        ;
;Now output data/clock to portb,4,5...
        BTFSS   carry           ;is it a one?
        GOTO    ASMBL3          ;No? Goto zero bit subroutine
        BSF     DATA            ;Yes? Set data bit high portb,4
ASMBL2  BSF     CLOCK       	;Set clock high portb,5
        NOP                     ;data clocks on +ve edge
        BCF     CLOCK           ;set clock low
        GOTO    ASMBL4          ;skip ASMBL3, no data bit
ASMBL3  BCF     DATA        	;Set up a data 0
        BSF     CLOCK           ;Set clock high portb,5
        NOP                     ;data clocks on +ve edge
        BCF     CLOCK           ;setclock low   
ASMBL4  DECFSZ  BITS,f          ;BIT-1=0?
        GOTO    ASMBL1           ;Loop until all 43
;43 BIT string is now assembled so load into display selector...
        BSF     LOAD            ;Latch data in LCD driver
        NOP                     ;Nice long pulse
        BCF     LOAD            ;End of load pulse and sequence.
        RETURN
;
;The display DISPLAY_DELAY routine slows the shifting digits on the LCD.
;The DISPLAY_DELAY section of this program acts as a general purpose timer.
;DISPLAY_DELAY=1.6[DS_DEL](base10)cubed+20[DS_DEL]uS
;Min(01H)=23uS/Max(0FFH)=68secs
;Typ...10H=20mS 20H=130mS 30H=450mS 40H=1sec
;
DISPLAY_DELAY               	;
	MOVLW   035H            ;Set value for scroll speed in <scrl_1-1.h>
	MOVWF	DS_DEL		;hold in DS_DEL
DELAY	MOVF    DS_DEL,w        ;w=display delay
	BTFSC	TST_DLY		;Test for FLAG1,4 (short test delay)
	MOVLW	01H		;short delay value
	MOVWF	PTR1		;Store delay value
      	MOVWF   ITER1           ;Load this value
       	MOVWF   ITER2           ;into ITER2
      	MOVWF   ITER3           ;and ITER3
LOOP_DD	DECF    ITER1,f    	;Inner Loop TEMP1
       	BTFSS   zero            ;Is ITER1 zero?
      	GOTO    LOOP_DD         ;No? Loop again
      	MOVWF   ITER1           ;reload
       	DECF    ITER2,f         ;ITER2-1
       	BTFSS   zero            ;Is ITER2 zero?
      	GOTO    LOOP_DD         ;No? loop again
      	MOVF    PTR1,w        	;Restore DISPLAY_DELAY value
      	MOVWF   ITER2           ;reload
      	DECF    ITER3,f         ;ITER3-1
      	BTFSS   zero            ;Is ITER3 zero?
     	GOTO    LOOP_DD         ;Loop again
        RETURN                  ;end of DISPLAY_DELAY
;
;Scroll complete display one digit to the left..
;
SCROLL_ONE                  	;
        MOVF    DISP5,w         ;Move DISP5 into
        MOVWF   DIGITS          ;DIGITS
        MOVLW   031H            ;Address of DISP4
	MOVWF   fsr             ;point to it
SCRL1  	MOVF    indf,w     	;place contents in w
        DECF    fsr,f           ;point to DISP5
        MOVWF   indf            ;move w into it
	INCF	fsr,f		;point to previous digit
	INCF	fsr,f		;point to previous digit
	MOVLW	01H		;W=01H
	ADDWF	SP1,w		;W=SP1+1
	SUBWF	fsr,w		;w=fsr-1
	BTFSS	zero		;End of scroll?
	GOTO	SCRL1		;No? Then loop
	MOVF	SP1,w		;W=SP1
	MOVWF	fsr		;FSR=SP1
        MOVF    DIGITS,w        ;Yes? Then
        MOVWF   indf          	;restore DISP5
	RETURN			;
;
;Turn on LED at each data update...
;
LED_ON  BSF     rb0         	;bank1
        MOVLW   00H             ;
        MOVWF   trisb           ;
        CLRF    status          ;bank0
LDO1    BSF     portb,3         ;Delay
	DECFSZ	ITER2,f		;the
	GOTO	LDO1		;turn-off	
        RETURN
;
;Turn off LED at each data update...
;
LED_OFF BSF     rb0        	;bank1
        MOVLW   00H             ;
        MOVWF   trisb           ;
        CLRF    status          ;bank0
        BCF     portb,3         ;
        RETURN			;
;
;******************************************************
