; file      : luts_1-0.inc
; author    : 
; date      : 14-SEP-1999
; purpose   : Display look-up table.
; used by   : Library routine
;
; Copyright (C) Lascar Electronics Ltd 1999
;
; This library is free software; you can redistribute it and/or
; modify it under the terms of the GNU Lesser General Public
; License as published by the Free Software Foundation; either
; version 2.1 of the License, or (at your option) any later version.
;
; This library is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; Lesser General Public License for more details.

; You should have received a copy of the GNU Lesser General Public
; License along with this library; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
; USA
;
;**************************************************************
;
; This is the assembly routine which enables the user to use indirect addressing
; to display the full character set on the MDM-1 LCD Display. By sending the ASCII
; equivalent of a character the routine will return the bit definitions to enable the 
; Display Routine to address the correct segments on the LCD.
; This look up table may be modified to define special characters or modify the appearance 
; of any of the character set.
; 
; **ASCII code to Display Segment Conversion Look-up Tables**
; **BCD to Binary Conversion Look-up Tables**

; This contains the binary definitions to enable swift Binary to BCD conversion.
; It is not recommended to modify these tables
;
;***Look-up Table for Segment Test***
;
	ORG	1800H	
SEGTAB  ADDWF   pcl,f        ;L1;Adds value in LUT_PTR	
        RETLW   b'00000001'     ;seg B or I   01H	 
        RETLW   b'00000010'     ;seg A or H   02H	 
        RETLW   b'00000100'     ;seg F or C   04H	 
        RETLW   b'00001000'     ;seg C or N   08H      	 
        RETLW   b'00010000'     ;seg D or M   10H	 
        RETLW   b'00100000'     ;seg E or L   20H	 
        RETLW   b'01000000'     ;seg J or K   40H	 
        RETLW   b'10000000'     ;seg O or R   80H
	RETLW	b'00000000'	;blank display	 
	BSF	LUT_FLG		;LUT end identifier		    O	AAAAAAA
	RETURN			;				       FG  H  IB
;							               F G H I B
;Look-up table selects digit display segments from		    R  F  GHI  B
;their ASCII values.							JJJ KKK
;16 bits are required to define each starburst digit		    R  E  LMN  C
;so that each digit requires 2 lines of look-up table		       E L M N C	
;lookup table A deals with segments BAFCDEJO on COM1		       EL  M  NC	
;lookup table B deals with segments IHGNMLKR on COM2		    O	DDDDDDD
;
;*****IMPORTANT NOTE: 	IF THE LCD IS REVERSED FOR 12 OCLOCK VIEWING ANGLE
;			THEN SEGMENTS J AND K MUST BE INVERTED WITHIN THE LOOKUPS
;			IE. CHANGE 0 TO 1 OR 1 TO 0.
;							 
LUT_A   ADDWF   pcl,f        ;L2;Adds ASCII to program counter
;
;				     ASCII    SEGMENT   	
;				   dec	hex	hex     
        RETLW   b'00000000'     ;SP 32  20	00	
        RETLW   b'00000000'     ;   33  21	00	user defined
        RETLW   b'00000000'     ;   34  22	00	user defined	
        RETLW   b'00000000'     ;   35  23	00	user defined
        RETLW   b'00000000'     ;   36  24	00	user defined
        RETLW   b'00000000'     ;   37  25	00	user defined
        RETLW   b'11100010'     ;o  38  26	E2	degree 
        RETLW   b'00011110'     ;o  39  27	1E	lower case
        RETLW   b'01101100'     ;[  40  28	6C	
        RETLW   b'11011000'     ; ] 41  29	D8	
        RETLW   b'00000010'     ;*  42  2A	02	
        RETLW   b'00000010'     ;+  43  2B	02
        RETLW   b'01000010'     ;ohm45  2D	02
        RETLW   b'00000010'     ;-  44  2C	02	
        RETLW   b'00000001'     ;.  46  2E	01	
        RETLW   b'00000000'     ;/  47  2F	00	
        RETLW   b'11111100'     ;0  48  30	FC      
        RETLW   b'10010000'     ;1  49  31	90	
        RETLW   b'11001110'     ;2  50  32	CE	
        RETLW   b'11011000'     ;3  51  33	D8	
        RETLW   b'10110010'     ;4  52  34	B2      
        RETLW   b'01111010'     ;5  53  35	7A	
        RETLW   b'01111110'     ;6  54  36	7E	
        RETLW   b'11010000'     ;7  55  37	D0	
        RETLW   b'11111110'     ;8  56  38	FE	
        RETLW   b'11111010'     ;9  57  39	FA	
        RETLW   b'00011100'     ;u  58	3A	1C	
        RETLW   b'01111010'     ;$  59	3B	7A	
        RETLW   b'00000000'     ;<  60	3C	00	
        RETLW   b'01001010'     ;  61	3D	4A	
        RETLW   b'00000000'     ;>  62	3E	00	
        RETLW   b'11100001'     ;?  63	3F	E1	
        RETLW   b'00010110'     ;m  64  40	16	
        RETLW   b'11110110'     ;A  65  41	F6      
        RETLW   b'11011000'     ;B  66  42	D8	
        RETLW   b'01101100'     ;C  67  43	6C	
        RETLW   b'11011000'     ;D  68  44	D8	
        RETLW   b'01101110'     ;E  69  45	6E	
        RETLW   b'01100110'     ;F  70  46	66	
        RETLW   b'01111100'     ;G  71  47	7C	
        RETLW   b'10110110'     ;H  72  48	B6	
        RETLW   b'01001000'     ;I  73  49	48	
        RETLW   b'10011100'     ;J  74  4A	9C	
        RETLW   b'00100110'     ;K  75  4B	26	
        RETLW   b'00101100'     ;L  76  4C	2C	
        RETLW   b'10110100'     ;M  77  4D	B4	
        RETLW   b'10110100'     ;N  78  4E	B4	
        RETLW   b'11111100'     ;O  79  4F	FC	
        RETLW   b'11100110'     ;P  80  50	E6	
        RETLW   b'11111100'     ;Q  81  51	FC	
        RETLW   b'11100110'     ;R  82  52	E6	
        RETLW   b'01111010'     ;S  83  53	7A	
        RETLW   b'01000000'     ;T  84  54	40	
        RETLW   b'10111100'     ;U  85  55	BC	
        RETLW   b'00100100'     ;V  86  56	24	
        RETLW   b'10111100'     ;W  87  57	BC
        RETLW   b'00000000'     ;X  88	58	00	
        RETLW   b'00000000'     ;Y  89	59	00	
        RETLW   b'01001000'     ;Z  90  5A	48	
        RETLW   b'01101100'     ;[  91  5B	6C
        RETLW   b'00000000'     ;\  92	5C	00	
        RETLW   b'11011000'     ;]  93  5D	D8	
        RETLW   B'00000000'     ;v  94	5E	00	
        RETLW   b'00001000'     ;_  95  5F	08H	
	BSF	LUT_FLG		;LUT end identifier
	RETURN
;       
;lookup table B deals with segments IHGNMLJR on COM2
;
LUT_B    ADDWF   pcl,f        ;L3;Adds ASCII to pc
;
;				    ASCII     SEGMENT   
;				  value	hex	hex     
        RETLW   b'00000000'     ;SP 32	20	00	
        RETLW   b'00000000'     ;   33	21	00	 user defined
        RETLW   b'00000000'     ;   34  22	00	 user defined	
        RETLW   b'00000000'     ;   35  23	00	 user defined
        RETLW   b'00000000'     ;   36  24	00	 user defined
        RETLW   b'00000000'	;   37	25	00	 user defined
        RETLW   b'00000010'     ;o  38	26	02	 degree
        RETLW   b'00000010'     ;o  39  27	02	 lower case o	
        RETLW   b'00000000'     ;[  40	28	00	 
        RETLW   b'00000000'     ;]  41	29	00	
        RETLW   b'11111110'     ;*  42  2A	FE	
        RETLW   b'01001010'     ;+  43  2B	4A
        RETLW   b'10100010'	;ohm45	2D	A2		
        RETLW   b'00000010'     ;-  44  2C	02	
        RETLW   b'00000000'     ;.  46	2E	00	
        RETLW   b'10000100'     ;/  47  2F	84	
        RETLW   b'00000000'     ;0  48	30	00	
        RETLW   b'00000000'     ;1  49	31	00	
        RETLW   b'00000010'     ;2  50  32	02	
        RETLW   b'00000010'     ;3  51  33	02	
        RETLW   b'00000010'     ;4  52  34	02	
        RETLW   b'00000010'     ;5  53  35	02	
        RETLW   b'00000010'     ;6  54  36	02	
        RETLW   b'00000000'     ;7  55	37	00	
        RETLW   b'00000010'     ;8  56  38	02	
        RETLW   b'00000010'     ;9  57  39	02	
        RETLW   b'00000000'     ;u  58  3A	42	
        RETLW   b'01001010'     ;$  59	3B	4A	
        RETLW   b'10010000'     ;<  60  3C	90	
        RETLW   b'00100110'     ;  61	3D	26	
        RETLW   b'00100100'     ;>  62  3E	24	
        RETLW   b'00001010'     ;?  63	3F	0A	
        RETLW   b'00001010'     ;m  64  40	0A	
        RETLW   b'00000010'     ;A  65  41	02	
        RETLW   b'01001010'     ;B  66  42	4A	
        RETLW   b'00000000'     ;C  67	43	00	
        RETLW   b'01001000'     ;D  68  44	48	
        RETLW   b'00000000'     ;E  69  45	00	
        RETLW   b'00000000'     ;F  70  46	00	
        RETLW   b'00000010'     ;G  71  47	02	
        RETLW   b'00000010'     ;H  72  48	02	
        RETLW   b'01001000'     ;I  73  49	48	        
	RETLW   b'00000000'     ;J  74	5A	00
        RETLW   b'10010000'     ;K  75  5B	90	
        RETLW   b'00000000'     ;L  76	5C	00	
        RETLW   b'10100000'     ;M  77  5D	A0	
        RETLW   b'00110000'     ;N  78	5E	30	
        RETLW   b'00000000'     ;O  79	5F	00	
        RETLW   b'00000010'     ;P  80	60	02	
        RETLW   b'00010000'     ;Q  81  61	10	
        RETLW   b'00010010'     ;R  82  62	12	
        RETLW   b'00000010'     ;S  83  63	02	
        RETLW   b'01001000'     ;T  84  64	48	
        RETLW   b'0000000'      ;U  85	65	00	
        RETLW   b'10000100'     ;V  86  66	84	
        RETLW   b'00001000'     ;W  87  67	08	
        RETLW   b'10110100'     ;X  88  68	B4	
        RETLW   b'10101000'     ;Y  89  69	A8	
        RETLW   b'10000100'     ;Z  90  6A	84	
        RETLW   b'00000000'     ;[  91	6B	00	
        RETLW   b'00110000'     ;\  92  6C	30	
        RETLW   b'00000000'     ;]  93	6D	00
        RETLW   b'10100000'     ;v  94	6E	A0
        RETLW   b'00000000'     ;_  95	6F	00
	BSF	LUT_FLG		;LUT end identifier
	RETURN
;
;LOOK-UP TABLE FOR BINARY TO BCD CONVERSION...
;
LUT_UN	ADDWF	pcl,f	     ;L4;Add BITS value to program counter
	RETLW	01H		;for BCD1
	RETLW	02H		;
	RETLW	04H		;
	RETLW	08H		;
	RETLW	06H		;
	RETLW	02H		;
	RETLW	04H		;
	RETLW	08H		;
	RETLW	06H		;
	RETLW	02H		;
	RETLW	04H		;
	RETLW	08H		;
	RETLW	06H		;
	RETLW	02H		;
	RETLW	04H		;
	RETLW	08H		;
	RETLW	06H		;
LUT_TN	ADDWF	pcl,f		;Add BITS value to program counter
	RETLW    0H		;for BCD2
	RETLW	 0H		;
	RETLW	 0H		;
	RETLW	 0H		;
	RETLW	01H		;
	RETLW	03H		;
	RETLW	06H		;
	RETLW	02H		;
	RETLW	05H		;
	RETLW	01H		;
	RETLW	02H		;;Test all ports as outputs...
	RETLW	04H		;
	RETLW	09H		;
	RETLW	09H		;
	RETLW	08H		;
	RETLW	06H		;
	RETLW	03H
LUT_HU	MOVWF	SP1		;SP1=w
	MOVLW	07H		;1st significant number
	SUBWF	SP1,f		;SP1(w)-7                                 
	BTFSS	carry		;If negative then no carry!
	RETLW	0H		;
	MOVF	SP1,w		;Restore w value
	ADDWF	pcl,f		;Add BITS value to program counter for BCD3
;	RETLW    0H		;0
;	RETLW	 0H		;1
;	RETLW	 0H		;2
;	RETLW	 0H		;3
;	RETLW	 0H		;4
;	RETLW	 0H		;5
;	RETLW	 0H		;6
	RETLW	01H		;7
	RETLW	02H		;
	RETLW	05H		;
	RETLW	 0H		;
	RETLW	 0H		;
	RETLW    0H		;
	RETLW	01H		;
	RETLW	03H		;
	RETLW	07H		;
	RETLW	05H
LUT_TH	MOVWF	SP1		;SP1=w
	MOVLW	0AH		;1st significant number
	SUBWF	SP1,f		;SP1(w)-A                                  
	BTFSS	carry		;If negative then no carry!
	RETLW	0H		;
	MOVF	SP1,w		;Restore w value
	ADDWF	pcl,f		;Add BITS value to program counter for BCD4
;	RETLW    0H		;0
;	RETLW	 0H		;1
;	RETLW	 0H		;2
;	RETLW	 0H		;3
;	RETLW	 0H		;4
;	RETLW	 0H		;5
;	RETLW	 0H		;6
;	RETLW	 0H		;7
;	RETLW	 0H		;8
;	RETLW	 0H		;9
	RETLW	 1H		;A
	RETLW	 2H		;
	RETLW    4H		;
	RETLW	08H		;
	RETLW	06H		;
	RETLW	02H		;
	RETLW	05H		;
LUT_TT	MOVWF	SP1		;SP1=w
	MOVLW	0EH		;1st significant number
	SUBWF	SP1,f		;SP1(w)-E                                  
	BTFSS	carry		;If negative then no carry!
	RETLW	0H		;
	MOVF	SP1,w		;Restore w value
	ADDWF	pcl,f		;Add BITS value to program counter for BCD5
;	RETLW    0H		;0
;	RETLW	 0H		;1
;	RETLW	 0H		;2
;	RETLW	 0H		;3
;	RETLW	 0H		;4
;	RETLW	 0H		;5
;	RETLW	 0H		;6
;	RETLW	 0H		;7
;	RETLW  	 0H		;8
;	RETLW	 0H		;9
;	RETLW	 0H		;A
;	RETLW	 0H		;B
;	RETLW    0H		;C
;	RETLW	 0H		;D
	RETLW	01H		;E
	RETLW	03H		;
	RETLW	06H		;
	BSF	LUT_FLG		;LUT end identifier
	RETURN
;
;****************************************************
