; file      : math_1-2.inc
; author    : 
; date      : 30-AUG-2002
; purpose   : Maths subroutines
; used by   : Library routine
;
; Copyright (C) Lascar Electronics Ltd 2002
;
; This library is free software; you can redistribute it and/or
; modify it under the terms of the GNU Lesser General Public
; License as published by the Free Software Foundation; either
; version 2.1 of the License, or (at your option) any later version.
;
; This library is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; Lesser General Public License for more details.

; You should have received a copy of the GNU Lesser General Public
; License along with this library; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
; USA
;
; 27/06/02 Subtraction and Addition Routine replaced with single addition routine
;	   with negative number handling
;
; 30/08/02 New Multiplication Routine added.  NB ACC4 is same address as DPM EQU
;
;**************************************************************

;Numerical input data is in BCD code (5 registers) BCD1 to BCD5(MSD)
;and the resultant output is held in the binary registers ACC1\2\3
;
;All mathematical operations are done in BINARY code
;and the results held in binary registers ACC1\2\3, these must be
;manually converted into the appropriately named registers for each
;maths input operation.
;
;Maths routine outputs can be converted to BCD code using registers BCD1 to 
;BCD5(MSD) by calling the BINARY_BCD subroutine.
;
;*******BCD to BINARY CONVERSION******* 
;
;BCD1[LSD] to BCD5[MSD] converted to the binary registers ACC1\2\3
;This operation is carried out twice for the two input numbers
;from the calling program...
;
TIMES_10
	BCF	carry		;Clear carry flag
	RLF	TEMP1,f		;TEMP1=BCD2 x2
	RLF	TEMP1,f		;TEMP1=BCD2 x4
	RLF	TEMP1,w		;w=BCD2 x8
	ADDWF	ACC1,f		;ACC1=BCD2 x8
	RLF	TEMP2,w		;BCD2 x2
	ADDWF	ACC1,f		;ACC1=BCD2 x10
	RETURN			;No? Then continue...
TIMES_25
	BCF	carry		;Clear carry flag
	RLF	TEMP2,f		;TEMP2=BCDn x2
	RLF	TEMP2,f		;TEMP2=BCDn x4
	RLF	TEMP2,f		;w=BCD2 x8
	RLF	TEMP2,w		;w=BCD2 x16
	MOVWF	TEMP3		;TEMP3=BCD2 x16
	CLRF	BITS		;Clear BITS
	MOVF	TEMP1,w		;w=BCDn
	ADDWF	BITS,f		;BITS=BCDn
	MOVF	TEMP2,w		;w=BCDn x9
	ADDWF	BITS,f		;BITS=BCDn x9
	MOVF	TEMP3,w		;w=BCDn x25
	ADDWF	BITS,f		;BITS=BCDn x25
ADD25	MOVF	BITS,w		;w=BCDn x25	
	ADDWF	ACC1,f		;ACC1=BCDn x25
	BTFSC	carry		;Overflow?
	INCF	ACC2,f		;Yes? Then ACC2+1
	BTFSC	zero		;Overflow?
	INCF	ACC3,f		;Yes? Then ACC3+1
	RETURN			;No? Then continue...
;Program proper starts here...
;Add BCD1 into ACC1...
BCD_BINARY
	CLRF	ACC1		;Clear 
	CLRF	ACC2		;Accumulator
	CLRF	ACC3		;
	MOVF	BCD1,w		;w=BCD1
	MOVWF	ACC1		;ACC1=BCD1
;Add BCD2 x10 into BIN_L...
	MOVF	BCD2,w		;w=BCD2
	MOVWF	TEMP1		;TEMP1=BCD2
	MOVWF	TEMP2		;TEMP2=BCD2
	CALL	TIMES_10	;BCD2 x10
;Add BCD3 x100 into ACC1...
	MOVF	BCD3,w		;w=BD3
	MOVWF	TEMP1		;TEMP1=BCD3
	MOVWF	TEMP2		;TEMP2=BCD3
	CALL	TIMES_25	;BCD3 x25
	CALL	ADD25		;BCD3 x50
	CALL	ADD25		;BCD3 x75
	CALL	ADD25		;BCD3 x100
	MOVF	BCD4,w		;w=BCD4		
	BTFSC	zero		;Is BCD4=0?
	GOTO	BCDB2		;Yes? Then skip to BCD5
;Add BCD4 x1000 into ACC1...
	MOVWF	TEMP1		;No? Then TEMP1=BCD4
	MOVWF	TEMP2		;TEMP2=BCD4
	CALL	TIMES_25	;BCD4 x25
	MOVLW	.39		;39x
	MOVWF	DIGITS		;40 loops
BCDB1	CALL	ADD25		;BCD4 x1000
	DECFSZ	DIGITS,f	;Enough?
	GOTO	BCDB1		;No? Then loop again
;Add BCD5 x10,000 into ACC1...
BCDB2	MOVF	BCD5,w		;w=BCD5
	BTFSC	zero		;Is BCD5=0?
	GOTO	BCDB5		;Yes? Then finish
	MOVWF	TEMP1		;No? Then TEMP1=BCD5
	MOVWF	TEMP2		;TEMP2=BCD5
	CALL	TIMES_25	;Yes? Then BCD5x25
	MOVLW	.199		;No? Then w=199x
	MOVWF	DIGITS		;199 loops
BCDB3	CALL	ADD25		;BCD5 x1000
	DECFSZ	DIGITS,f	;Enough?
	GOTO	BCDB3		;No? Then loop again
	MOVLW	.200		;200x
	MOVWF	DIGITS		;400 loops altogether
BCDB4	CALL	ADD25		;BCD5 x10000
	DECFSZ	DIGITS,f	;Enough?
	GOTO	BCDB4		;Loop again
BCDB5	NOP			;
	RETURN			;Yes? Finish...
;
;**************************************************************
;
;NEGATIVE NUMBER SUBROUTINE FOR MULTIPLY\DIVIDE
;
MD_NEG	BTFSC	NEGF1	      ;1;Is 1st No.-ve
	GOTO	MDN1		;Yes1? Then is 2nd No.-ve?
	BTFSS	NEGF2	      ;2;No1? Then is 2nd No.-ve?
	GOTO	MDN2		;No2? finish
	BSF	NEGF1		;Yes2? Then SET NEGF1
	BCF	NEGF2		;and clear NEGF2
	GOTO	MDN2		;and finish
MDN1	BTFSS	NEGF2	      ;3;Is 2nd No. -ve?
	GOTO	MDN2		;No? Then finish
	BCF	NEGF1		;Yes? Then clear both
	BCF	NEGF2		;-ve flags
MDN2	NOP
	RETURN
;
;***MULTIPLICATION SUBROUTINE...
;
; unsigned multiply of MCNDH/L with MPLRH/L result in ACC4/3/2/1
; This program looks at the lsb of MCANDL to decide whether to add MPLRL to res2
; and MPLRH to res3, with appropriate carrys
; It then looks at the lsb of MCNDH to decide whether to add MPLRL to res3
; and MPLRH to res4, again with appropriate carrys.
; The rotates then only have to be done 8 times
; Result registers used as loop counter
;
MULTIPLICATION
        CLRF    ACC4
        CLRF    ACC3
        CLRF    ACC2
	MOVLW	0x80
        MOVWF   ACC1     
NXTBIT  RRF     MCNDH,f
        RRF     MCNDL,f
        BTFSS   carry
	GOTO	NOBIT_L
        MOVF    MPLRL,w
        ADDWF   ACC2,f
        MOVF    MPLRH, w
        BTFSC   carry
        INCFSZ  MPLRH, w 
        ADDWF   ACC3, f 
        BTFSC   carry
        INCF    ACC4, f
        BCF     carry
NOBIT_L	BTFSS   MCNDL, 7
	GOTO	NOBIT_H
        MOVF    MPLRL,w
        ADDWF   ACC3,f
        MOVF    MPLRH, w
        BTFSC   carry
        Incfsz  MPLRH, w
        Addwf   ACC4, f 
NOBIT_H RRF     ACC4,f
        RRF     ACC3,f
        RRF     ACC2,f
        RRF     ACC1,f
        Btfss   carry
	GOTO	NXTBIT
;Now output result
MUL8	CALL	MD_NEG		;Set negative flags
	NOP
	RETURN			;To main program...
;
;***************************************************************
;
;***DIVISION SUBROUTINE...
;
;Division of a 24bit by a 16bit binary number
;accepted as DVD1\2\3 divided by DVRH\L
;The two binary numbers are generated calling from
;the main calling program and converted into the appropriately
;named registers for the different maths routines.
;
;***DVD1\2\3 divided by DVRL/H=DIVIDE COUNTER (DCR1\2\3)+rem
;DVRL\H is held in DVR1\2\(3) and
;DVD1\2\3 is held in the partial dividend registers PD1\2\3
;Remainder=partial dividend-divisor PD-DVR and is held in REM1\2\3
;When REM1 goes -ve, then PD=previous REM and ACC=ACC+DCR 
;If REM=0 or REM<DVRL\H then the product is returned in ACC1\2\3
;Because of the limitation of the DCR registers the maximum product
;can not exceed 1,048,576(10,00,00H) 
; 
DIVISION			;Initialise registers...
	CLRF	ACC1		;Clear O/P registers
	CLRF	ACC2		;Clear O/P registers
	CLRF	ACC3		;Clear O/P registers
	MOVF	DVRL,w		;
	MOVWF	DVR1		;	
	MOVF	DVRH,w		;
	MOVWF	DVR2		;
	CLRF	DVR3		;
;Is divisor zero?
	MOVF	DVRH,w		;w=DVRH
	BTFSS	zero		;Is DVRH=zero?
	GOTO	DIV1		;No? Then test DVDH for zero
	MOVF	DVRL,w		;Yes? Then test DVRL for zero
	BTFSS	zero		;Is DVRL=zero?
	GOTO	DIV1		;No? Then test DVDH
	GOTO	QUOT0		;Yes? Then QUOT=0
;Is dividend zero?
DIV1	MOVF	DVD3,w		;w=DVD3
	BTFSS	zero		;Is DVD3=zero?
	GOTO	DIV2		;No? Then test if DVR>DVD
	MOVF	DVD2,w		;Yes? Then test DVD2 for zero
	BTFSS	zero		;Is DVD2=zero?
	GOTO	DIV2		;No? Then test DVR>DVD
	MOVF	DVD1,w		;Yes? Then test DVD1 for zero
	BTFSS	zero		;Is DVD1=zero?
	GOTO	DIV2		;No? Then test DVR>DVD
	GOTO	QUOT0		;Yes? Then QUOT=0
;Is divisor bigger than the dividend?
DIV2	MOVF	DVD3,w		;w=DVD3
	SUBWF	DVR3,w		;DVR3-DVD3	;If -ve then no carry
	BTFSS	carry		;If DVD3>DVR3 then no carry
	GOTO	DIV3		;No? Then start
	MOVF	DVD2,w
	SUBWF	DVR2,w
	BTFSS	carry
	GOTO	DIV3
	MOVF	DVD1,w
	SUBWF	DVR1,w
	BTFSC	carry
	GOTO	QUOT0		;Yes? Then QUOT=0
;Main Divide routine starts here...
;Hold DVD1\2\3 in PP1\2\3 partial product registers...
;and DVRL\H in DIV_L\H
DIV3	MOVF	DVD1,w		;w=DVD1		;Hold
	MOVWF	PD1		;PD1=DVD1	;dividend
	MOVF	DVD2,w		;w=DVD2		;in
	MOVWF	PD2		;PD2=DVD2	;PD1\2\3
	MOVF	DVD3,w		;w=DVD3
	MOVWF	PD3		;PD3=DVD3
;Start new iteration...
DIV4	CLRF	REM1		;Clear
	CLRF	REM2		;remainder
	CLRF	REM3		;registers
	MOVF	DVRL,w		;w=DVRL	     ;Hold
	MOVWF	DVR1		;DVR1=DVRL   ;divisor
	MOVF	DVRH,w		;w=DVRH	     ;in
	MOVWF	DVR2		;DVR2=DVRH   ;DVR1\2\(3)
	CLRF	DVR3		;DVR3=0
	CLRF	DCR3		;Set 
	CLRF	DCR2		;DIVIDE
	MOVLW	01H		;counter
	MOVWF	DCR1		;to 1
;PD1\2\3>REM1\2\3 partial dividend test
;Subtract DVR1\2\3 from PD12\3 and hold in REM12\3
DIV5	MOVF	DVR1,w		;w=DVR1
	SUBWF	PD1,w		;PD1-DVR1
	BTFSS	carry		;DVR1>PD1?
	GOTO	DIV11		;No? Overflow
 	MOVWF	REM1		;REM1=PD1-DVR1
	MOVF	DVR2,w		;w=DVR2
DIV5A	SUBWF	PD2,w		;PD2-DVR2
	BTFSS	carry		;DVR2>PD2?
	GOTO	DIV12		;No? Overflow  
	MOVWF	REM2		;Yes? Then REM2 updated
DIV5B	MOVF	TEMP3,w		;restore TEMP3;DVR3+1
	BTFSC	zero		;If zero ignore
	MOVF	DVR3,w		;and use w=DVR3
	SUBWF	PD3,w		;PD3-DVR3
	CLRF	TEMP3		;TEMP3=0
	BTFSS	carry		;DVR3>PD3?
	GOTO	DIV7		;Yes? Then correct overshoot...  
	MOVWF	REM3		;No? Then REM3 updated
;Double the divisor and divide-counter...
DIV6	BCF	carry		;clear carry
	RLF	DVR1,f		;Divisor Lo-byte x2
	RLF	DVR2,f		;Divisor 2nd-byte x2
	RLF	DVR3,f		;Divisor Hi-byte x2
	BCF	carry		;Clear carry	
	RLF	DCR1,f		;Multiply DIVIDE 
	RLF	DCR2,f		;counter
	RLF	DCR3,f		;by 2
	GOTO	DIV5		;continue interation
;Return to previous position...
DIV7	BCF	carry		;Clear carry		
	RRF	DVR3,f		;divide binary 
	RRF	DVR2,f		;divisor
	RRF	DVR1,f		; by 2
	BCF	carry		;Clear carry
	RRF	DCR3,f		;Divide  
	RRF	DCR2,f		;DIVIDE
	RRF	DCR1,f		;counter by 2
	GOTO	DIV8			
;Restore correct values after overshooting REM1\2\3...
DIV8A	INCFSZ	DVR2,w		;w=DVR2+1
	GOTO	DIV8B		;not zero
	MOVWF	TEMP2		;TEMP2=DVR2+1
	INCF	DVR3,w		;w=DVR3+1
	MOVWF	TEMP3		;TEMP3=DVR3+1
	MOVF	TEMP2,w		;restore DVR2+1
	GOTO	DIV8B
DIV8D	INCF	DVR3,w		;w=DVR3+1
	GOTO	DIV8C	
DIV8	CLRF	TEMP3		;TEMP3=0
	MOVF	DVR1,w		;restore DVR1
	SUBWF	PD1,w		;w=PD1-DVR1
	MOVWF	REM1		;REM1=w=PD1-DVR1
	BTFSS	carry		;Was PD1<DVR1
	GOTO	DIV8A		;-ve result
	MOVF	DVR2,w		;Restore DVR2
DIV8B	SUBWF	PD2,w		;w=PD2-DVR2
	MOVWF	REM2		;REM=PD2-DVR2
	BTFSS	carry		;Was PD2<DVR2
	GOTO	DIV8D		;-ve result
	MOVF	DVR3,w		;restore DVR3
DIV8C	SUBWF	PD3,w		;w=PD3-DVR3
	MOVWF	REM3		;Drop through
;Update Accumulator from binary counter...
	MOVF	DCR1,w		;w=DCR1
	ADDWF	ACC1,f		;ACC1=ACC1+DCR1
	BTFSC	carry		;Overflow?
	INCF	ACC2,f		;Yes? Then ACC2+1
	MOVF	DCR2,w		;w=DCR2
	ADDWF	ACC2,f		;ACC2=ACC2+DCRH
	BTFSC	carry		;Overflow?
	INCF	ACC3,f		;Yes? Then ACC3+1
	MOVF	DCR3,w		;w=DCR3
	ADDWF	ACC3,f		;ACC3=ACC3+DCR3
;Update PD1\2 registers...
	MOVF	REM1,w		;w=REM1
	MOVWF	PD1		;PD1=REM1
	MOVF	REM2,w		;w=REM2
	MOVWF	PD2		;PD2=REM2
	MOVF	REM3,w		;w=REM3
	MOVWF	PD3		;PD3=REM3
;Is REM1\2\3=0? Final zero Test!
DIV9	MOVF	REM3,w		;w=REM3
	BTFSS	zero		;REM3=0?
	GOTO	DIV10		;No? Then test for REM<DVRL\H
	MOVF	REM2,w		;w=REM2
	BTFSS	zero		;REM2=0?
	GOTO	DIV10		;No? Then test for REM<DVRL\H
	MOVF	REM1,w		;w=REM1
	BTFSS	zero		;REM1=0?
	GOTO	DIV10		;No? Then test for REM<DVRL\H
	GOTO	QUOT2		;Yes? Then finish	
;Is the divisor DVRL\H > the remainder REM1\2\3? Final Test!
DIV10A	INCF	DVRH,w		;Then w=DVRH+1
	GOTO	DIV10B
DIV10	MOVF	REM3,w		;w=REM3
	BTFSS	zero		;Is REM3=0
	GOTO	DIV4		;No? Then next itineration...
	MOVF	DVRL,w		;No? Then restore divisor Lo-byte
	SUBWF	REM1,w		;w=REM1-DVRL
	BTFSS	carry		;Is DVR1>REM1? (no carry)
	GOTO	DIV10A		;Yes? Then DVRH+1
	MOVF	DVRH,w		;No? Then restore divisor Hi-byte
DIV10B	SUBWF	REM2,w		;w=REM2-DVRH
	BTFSS	carry		;Is DVRH>REM2? no carry!
	GOTO	QUOT2		;Yes? Then finish...
	GOTO	DIV4		;No? Then next itineration... 
;Overflow routine for DVR1 subtraction, temporarily increment 
;DVR2 for repeating the subtraction... 
DIV11	CLRF	TEMP2		;TEMP1=0
	CLRF	TEMP3		;TEMP2=0
	MOVWF	REM1		;REM1=w update REM1
	INCFSZ	DVR2,w		;w=DVR2+1
	GOTO	DIV5A		;repeat division...
	MOVWF	TEMP2		;hold DVR2 in TEMP2
	INCF	DVR3,w		;If DVR2+1=0;then w=DVR3+1
	MOVWF	TEMP3		;hold in TEMP1
	MOVF	TEMP2,w		;restore DVR2
	GOTO	DIV5A		;repeat division...
;Overflow routine for DVR2 subtraction, temporarily increment 
;DVR3 for repeating the subtraction... 
DIV12	MOVWF	REM2		;REM2=PD2-DVR2
	INCF	DVR3,w		;w=DVR3
	MOVWF	TEMP3		;TEMP3=DVR3+1
	GOTO	DIV5B		;repeat division...
;
;'DIVIDE' operation results...
QUOT2	CALL	MD_NEG		;Set negative flags
QUOT0	NOP
	RETURN			;To main program...
;
;*****************************************************************
; NEW ADDITION SUBROUTINE
; ADDS ADD1H/L TO ADD2H/L
; NEGF1/2 TO NEGATE EITHER
; ANSWER IN ACC1/2/3, NEGF1 SET IF NEG

ADDITION
        MOVF    ADD1H,F         ;Test zero
        BTFSS   zero
	GOTO	ADD15
	MOVF	ADD1L,F
        BTFSC   zero
	BCF	NEGF1
ADD15	MOVF	ADD2H,F		;Test zero
        BTFSS   zero
	GOTO	ADD14
	MOVF	ADD2L,F
        BTFSC   zero
	BCF	NEGF2
ADD14	CLRF	ACC3
	CLRF	ACC2
	CLRF	ACC1
	BTFSC	NEGF1		;Complement negative numbers
	COMF	ADD1H,F
	BTFSC	NEGF1
	COMF	ADD1L,F
	BTFSC	NEGF1
	INCF	ACC1,F		;Completes negation
	BTFSS	NEGF1
	INCF	ACC3,F		;Now contains 64k + ADD1H/L

	BTFSC	NEGF2
	COMF	ADD2H,F
	BTFSC	NEGF2
	COMF	ADD2L,F
	BTFSC	NEGF2
	INCF	ACC1,F
	BTFSS	NEGF2
	INCF	ACC3,F		;Now contains 64k + ADD2H/L

	MOVF	ADD1L,W		;Add the two numbers
	ADDWF	ACC1,F
        BTFSC   carry
	INCF	ACC2,F
	MOVF	ADD2L,W
	ADDWF	ACC1,F
        BTFSC   carry
	INCF	ACC2,F
	MOVF	ADD1H,W
	ADDWF	ACC2,F
        BTFSC   carry
	INCF	ACC3,F
	MOVF	ADD2H,W
	ADDWF	ACC2,F
        BTFSC   carry
	INCF	ACC3,F

	BCF	NEGF1
	BCF	NEGF2

	BTFSC	ACC3,1
	GOTO	POS
	BSF	NEGF1
	COMF	ACC1
	COMF	ACC2
	COMF	ACC3
	MOVLW	1
	ADDWF	ACC1,F
        BTFSC   carry
	ADDWF	ACC2,F
        BTFSC   carry
	ADDWF	ACC3,F
POS	MOVLW	B'00000001'
	ANDWF	ACC3,F
	RETURN
	               
;***********************************************************

;***BINARY TO BCD (BINARY CODED DECIMAL) CONVERSION***
;
;Converts  a 3 register binary number into 5 register 
;binary coded decimal..BCD1[LSD] to BCD5[MSD]
;
;Inputs are accepted in ACC1\2\3 8bit registers and transferred
;to the BCD\1\2\3\4\5 registers...
;Transfer values are made via the BIN to BCD LUT tables in
;<LUT_1-1.inc
;
BINARY_BCD
	CLRF	BCD1		;Clear BCD registers
	CLRF	BCD2		;
	CLRF	BCD3		;
	CLRF	BCD4		;
	CLRF	BCD5		;
	MOVLW	0FFH		;BITS
	MOVWF	BITS		;=-1
	MOVLW	09H		;w=9
	MOVWF	TEMP4		;TEMP4=9
	MOVF	ACC1,w		;Move ACC registers 
	MOVWF	TEMP1		;to TEMP registers
	MOVF	ACC2,w		;
	MOVWF	TEMP2		;
	MOVF	ACC3,w		;
	MOVWF	TEMP3		;
BINB1	BCF	C_FLG		;Clear the 'CARRY SET' set flag
	RRF	TEMP3,f		;Right shift the
	RRF	TEMP2,f		;binary values
	RRF	TEMP1,f		;into the carry position
	BTFSC	carry		;Was there a carry?
	BSF	C_FLG		;Yes? Then set carry flag
	INCF	BITS,f		;BITS+1
	MOVLW	.17		;17 bits shifted
	SUBWF	BITS,w		;w=BITS-16
	BTFSC	zero		;BITS=17?
	GOTO	BINB6		;Yes? Then finish
	BTFSS	C_FLG		;No? Then test for a '1' from shift
	GOTO	BINB1		;No? Then next shift
	MOVF	BITS,w		;Yes? Then get BITS value
	CALL	LUT_UN		;Fetch the units binary value
	ADDWF	BCD1,f		;and add into BCD1
	MOVF	BCD1,w		;w=BDC1
	SUBWF	TEMP4,w		;9-BCD1
	BTFSC	carry		;Is 9-BCD1 -ve?
	GOTO	BINB2		;No? Then continue...
	MOVWF	DIGITS		;rem
	COMF	DIGITS,w	;compl_rem
	MOVWF	BCD1		;Yes? Then BCD1=rem
	INCF	BCD2,f		;and BCD2+1
BINB2	MOVF	BITS,w		;Restore the BITS value
	CALL	LUT_TN		;Fetch the tens binary value
	ADDWF	BCD2,f		;and add into BCD2
	MOVF	BCD2,w		;w=BDC2
	SUBWF	TEMP4,w		;9-BCD2
	BTFSC	carry		;Is 9-BCD2 -ve?
	GOTO	BINB3		;No? Then continue...
	MOVWF	DIGITS		;rem
	COMF	DIGITS,w	;compl_rem
	MOVWF	BCD2		;BCD2=rem
	INCF	BCD3,f		;and BCD3+1	
BINB3	MOVF	BITS,w		;Restore the BITS value
	CALL	LUT_HU		;Fetch the hundreds binary value
	ADDWF	BCD3,f		;and add into BCD3
	MOVF	BCD3,w		;w=BCD3
	SUBWF	TEMP4,w		;9-BCD3
	BTFSC	carry		;Is 9-BCD3 -ve?
	GOTO	BINB4		;No? Then continue...
	MOVWF	DIGITS		;rem
	COMF	DIGITS,w	;compl_rem
	MOVWF	BCD3		;BCD3=rem
	INCF	BCD4,f		;BCD4+1
BINB4	MOVF	BITS,w		;Yes? Then get BITS value
	CALL	LUT_TH		;Fetch the thousands binary value
	ADDWF	BCD4,f		;and add into BCD4
	MOVF	BCD4,w		;w=BCD4
	SUBWF	TEMP4,w		;9-BCD4
	BTFSC	carry		;Is 9-BCD4 -ve?
	GOTO	BINB5		;No? Then continue...
	MOVWF	DIGITS		;rem
	COMF	DIGITS,w	;compl_rem
	MOVWF	BCD4		;BCD4=rem
	INCF	BCD5,f		;BCD5+1
BINB5	MOVF	BITS,w		;Then get BITS value
	CALL	LUT_TT		;Fetch the tens of K binary value
	ADDWF	BCD5,f		;and add into BCD5
	GOTO	BINB1		;Loop again...
BINB6	NOP			;
	RETURN			;Yes? Then finish
;
;****************************************************************

	 
				 


	
	
	
