; file      : mdm_1-3.asm
; author    : 
; date      : 30-AUG-2002
; purpose   : Master Software
; used by   : 
;
; Copyright (C) Lascar Electronics Ltd 2002
;
; This library is free software; you can redistribute it and/or
; modify it under the terms of the GNU Lesser General Public
; License as published by the Free Software Foundation; either
; version 2.1 of the License, or (at your option) any later version.
;
; This library is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; Lesser General Public License for more details.

; You should have received a copy of the GNU Lesser General Public
; License along with this library; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
; USA
;
; 30/08/02 	include defn_1-1.h added, previously defn_1-0.h
;		include math_1-2.inc added, previously math_1-1.h
;
;**************************************************************
;   
;uP             C16F877			     
;CLOCK          4MHz XTL		      
;IPS            1M			       	
;FUNCTION       LASCAR MDM_1 SHELL PROGRAM
;EQUATES        UPPER CASE = INVENTED NAMES
;               lower case = PIC names.
;DISPLAY	MSD=DIG5	LSD=DIG1
;		DIG25=last digit in scroll
;
;**************************************************************
;
;
;
        __config H'3FB9'        ; --11 1111 1011 1001

; --11 ---- --11 ---- Code Protection OFF
; ---- 1--- ---- ---- Debug OFF
; ---- -x-- ---- ---- Unimplemented
; ---- --1- ---- ---- Flash Write Enable
; ---- ---1 ---- ---- EEPROM protect OFF
; ---- ---- 1--- ---- LVP enabled
; ---- ---- -0-- ---- BOR disabled
; ---- ---- ---- 1--- PWRTE disabled
; ---- ---- ---- -0-- WDT disabled
; ---- ---- ---- --01 XT Oscillator
;
;**************************************************************
;***SPECIAL FUNCTION REGISTER EQUATES...
;

#include sfr_1-0.h



;**************************************************************
;***USER REGISTER DEFINITIONS...

#include defn_1-1.h



;**********************
;RESET VECTORS
;**********************

	ORG     00H	    	;Memory start address
	NOP
	BSF	rp3		;Set page 2
	GOTO    INIT    	;Program starts at INIT (on page 2)

	ORG	04H		;Interrupt vector
	GOTO	ISR		;Interupt service routine



;**************************************************************	
;***LOOK-UP  TABLES (LUTs)... 	at top of program memory page
;
;				;SEGTAB - Segment test table
;				;LUT_A - Character 'A' table
;				;LUT_B - Character 'B' table
;				;LUT_UN\TE\HU\TH\TT
;				;Binary to BCD tables

	ORG	1800H		;Page 3

#include luts_1-0.inc	



;**************************************************************
;***LUT MANAGEMENT & DISPLAY DRIVER SUBROUTINES***
;
;DIGIT ORDER...5 4 3 2 1   SHIFT register order 5 4 3 2 1
;The Digit Position Modifier (DPM) moves the positions of the
;displayed digits to the left.
;
;The LCD Driver accepts two data blocks A&B of 42 bits 
;corresponding to 42 segments, 5 digits. A 43rd bit in SHIFTX
;[020H] sets which block is Lo-COM1/Hi-COM2
;
;The DISPLAY_DELAY routine defines the period the display
;shows on the LCD and also is used to slow the shifting digits on
;the LCD.
;The DELAY section of this program acts as a general purpose timer.
;
;DISPLAY_DELAY=1.6[DS_DEL](base10)cubed+20[DS_DEL]uS
;Min(01H)=23uS/Max(0FFH)=68secs
;Typ...10H=20mS 20H=130mS 30H=450mS 40H=1sec
;
;Clear digit registers for blanking display on data input via RX.
;

#include ltdd_1-0.inc		;Page 3

#include efwr_1-0.inc		;Page 3


;****************************************************************
;***MATHEMATICS SUBROUTINES***
;***CONVERSION SUBROUTINES***	
;***BCD TO BINARY***
;
;Converts a 5 register BCD number BCD1\2\3\4\5  
;into 3 BINARY registers ACC1\2\3
;
;The ACC registers must be converted manually in software to
;the appropriately named maths registers.
;
;***NEGATIVE NUMBERS ROUTINE***
;Negative numbers must be flagged [NEGF1\2] 
;Negative mathematical results are flagged by NEGF1 being set.
;
;***MULTIPLICATION***
;Multiplies two 16bit binary numbers in MCNDL\H and MPLRL\H
;Outputs the product in ACC1\2\3\4
;
;***DIVISION***
;Divides a 24bit binary number in DVD1\2\3 with a 16bit binary number 
;in DVDL\H and DVRL\H and outputs the quotient in ACC1\2\3
;
;***ADDITION***
;Adds two 16bit binary numbers in ADD1L\H and ADD2L\H
;Outputs the sum in ACC1\2\3
;
;***SUBTRACTION***
;Subtraction uses addition with negative number flags
;Outputs the sum in ACC1\2\3
;
;***BINARY TO BINARY CODED DECIMAL***
;Converts a 3 register binary number ACC1\2\3 into 5  
;BCD registers BCD1\2\3\4\5
;

#include math_1-2.inc		;Page 3



;****************************************************************
;***SELF-TEST***
;***PRODUCTION TEST***
;

#include test_1-0.inc           ;Page 3



;****************************************************************
;***KEYPAD INPUT***
;
;
#include 4X4_1-0.inc		;Page 3



;****************************************************************
;***MESSAGE TABLE AND MESSAGE HEADER***
;
;Assorted messages for warnings and alarms outputted
;on ports RB<0,1,6,7>

#include mess_1-0.h		;Page 3
#include mtab_1-0.inc		;Page 3



;****************************************************************
;***USER VOLTMETER PROGRAM***
;
;Called from WINDOWS\PC via RS232 or by taking RC0 pin13 Hi.
;Input on RA0 pin4, default FSR=5v using Vss(5v) as ref. Accuracy=1024bits
;resolution=5mV.
;For 50v FSR 50mV resolution use x10 scaling resistors and shift d.p. to
;digit 2 by taking RD2 pin32 Hi.
;For 1volt FSR, resolution=1mV use 1.0v Ref.(on RA3+ and RA2-) by taking
;RD7 pin27 Hi. Use apropriate scaling resistors for other FSRs.
;Defalt DP position digit 2. To move DP to digit 3 take RD3 pin34 Hi. 
;Lo warning output on RB0	Hi warning output on RB1
;Lo alarm output on RB6		Hi alarm output on RB7
;Warnings and Alarms inhibited/reset by taking RD0 Hi
;Blank leading zeros by taking RD1 pin30 Hi

	ORG	1000H		;Page 2 start vector

#include volt_1-1.h		;Page 2
#include volt_1-1.inc		;Page 2



;****************************************************************
;***USER THERMOMETER PROGRAM***
;
;Called from WINDOWS\PC via RS232 or by taking RC1 pin26 Hi.
;Default 0 to +99.9C FSR Ref=Vss(5v) Accuracy=1024bits, resolution 0.1C.
;0 to 212F FSR, (resolution 0.2F) by taking RD6 pin29 Hi.
;273 to 373 Absolute, (resolution 0.2) by taking RD7 pin27 Hi
;Default DP is position 2. To move DP to digit 3 take RD3 pin34 Hi.
;Lo warning output on RB0	Hi warning output on RB1
;Lo alarm output on RB6		Hi alarm output on RB7
;Warnings and Alarms inhibited/reset by taking RD0 Hi
;Blank leading zeros by taking RD1 pin30 Hi
;
	ORG	1200H

#include thrm_1-0.h		;Page 2
#include thrm_1-0.inc		;Page 2



;****************************************************************
;***USER COUNTER PROGRAM***
;
;Called from WINDOWS\PC via RS232 or by taking RC2 pin24 Hi.
;5digit UP/DOWN(RD6 pin29 Hi)  counter with over/underflow count message.
;Lo warning output on RB0	Hi warning output on RB1
;Lo alarm output on RB6		Hi alarm output on RB7
;Warnings and Alarms enabled by taking RD0 Hi
;Blank leading zeros by taking RD1 pin30 Hi
;Counter reset by taking RD5 pin31 Hi.
;Blank leading zeros by taking RD1 pin30 Hi
;
	ORG	1400H
	
#include cntr_1-0.h		;Page 2
#include cntr_1-0.inc		;Page 2



;****************************************************************
;***USER MESSAGE PROGRAM***
;
;Called from WINDOWS\PC via RS232 or by taking RC3 pin20 Hi*.
;Eight 25character user input messages via PC keyboard or from 4x4 keypad.
;Each message can be displayed by taking each of RD0 to RD7 pins27 to 33 Hi
;Only characters within the ASCII range of 20H to 96H are recognised,
;all others are converted to 'space'.
;
	ORG	1600H

#include mess_1-1.inc		;Page 2	



;****************************************************************
;***DISPLAYS WARNING AND ALARM MESSAGES***

	ORG	1720H

#include alm_1-0.inc		;page 2



;****************************************************************

	ORG	1750H	

INIT	
	BSF	rb0		;bank one
	BSF	trisa,2		;portc,2 as input
	BCF	rb0		;bank zero
;***************************************************************
;***MAIN PROGRAM STARTS HERE***
;CLEAR ALL REGISTERS...

AUTOCLR
	MOVLW	020H		;Start of RAM address
	MOVWF	fsr		;point to it
ACLR	CLRF	indf		;clear it
	INCF	fsr,f		;next RAM address
	MOVLW	05DH		;End of RAM address
	SUBWF	fsr,w		;subtract from fsr
	BTFSS	zero		;are we thare yet?
	GOTO	ACLR		;No? Then loop...
				;Yes? Then drop through...
	BCF	TST_DLY		;No short delay flag (FLAG1,4)
;***************************************************************
;DISPLAY MDM_1 MESSAGE
MDM_1	BCF	rb0		;set
	BSF	rb1		;bank2
	MOVLW	40H		;w=vector for MDM_1
	MOVWF	EEP2		;EEP2 = MDM_1
	CALL	READ_MESSB	;Display message
;***************************************************************
;Set-up I/O port configurations
;All ports clear and default to input on power-up.
;Each program sets its own port requirements...

MD_TEST	BCF	rp2		;Page2
	BSF	pclath,1	;
	BSF	rb0		;bank1
	MOVLW	04H		;Set porta,2
	MOVWF	adcon1		;digital
				;Mode Test Routine- which pin is Hi?
	BCF	rb0		;bank0
	BTFSC	porta,2		;RS232?
	GOTO	ASYNCH		;Yes, goto ASYNCH
				;No, drop through and check 
				;If pins are set to configure
;***************************************************************
;Check portc for module configuration	
CHECK_PORTC
	BTFSC	portc,0
	GOTO	VOLT_PROG
	BTFSC	portc,1
	GOTO	THERM_PROG
	BTFSC	portc,2
	GOTO	COUNT_PROG
	BTFSC	portc,3
	GOTO	MESS_MESS_RD
	BTFSC	portc,4
	GOTO	PRODT		
;***************************************************************
;Check EEPROM for module configuration
CHECK_CONFIG
	BCF	rb0		;set
	BSF	rb1		;bank2
	BSF	pclath,0
	BSF	pclath,1
	BSF	pclath,2
	MOVLW	0FFH		;Move 1900H 
	MOVWF	eeadr		;into W and
	BSF	rp2		;page3
	CALL	RD_EEPROM	;read from EEPROM
	BCF	rp2		;page2
	MOVF	eedata,w	;retrieve data 
	ADDLW	01H		;W+1=W (FF+1=0, 0+1=1 ETC.)
	ADDWF	pcl,f		;Which module is selected?
	GOTO	PRODT		;None (FFH) run the production test
	GOTO	VOLT_PROG	;Volts module (0H)
	GOTO	THERM_PROG	;Temp module (1H)
	GOTO	COUNT_PROG	;Count modul (2H)
	GOTO	MESS_MESS_RD	;Message module (3H)
;***************************************************************
;If unconfigured run the production test program
PRODT	BSF	rp2		;page3
	BCF	pclath,0
	BCF	pclath,1
	BCF	pclath,2
	BCF	rb1		;bank0
	GOTO	PROD_TEST			
;***************************************************************
;***SET-UP FOR ASYNCH RECEIVE***
;When the RS232 port is active ie connected to a PC RA2 pin8 is forced Hi.
;Data is received on RC7 pin5 and transmitted on RC6 pin7
;On reception flag RCIF is set and is cleared by reading the RCREG
;Note: On power-up all tris registers default to inputs (1s)

ASYNCH	
	BSF	rb0		;bank one
	MOVLW	B'10011111'	;set bits 5,6 of
	MOVWF	trisc		;port c as outputs
	MOVLW	.25		;set baud rate
	MOVWF	spbrg		;
	MOVLW	b'00100100'	;8bit transmit, transmitter enabled,
	MOVWF	txsta		;asynchronous mode, high speed mode
	BCF	rb0		;bank zero
	MOVLW	b'10010000'	;8 bit recieve, reciever enabled,
	MOVWF	rcsta		;serial port enabled
	CLRF	rcreg

LOOK_BS1
     	BTFSS	rcif		;Have we received a byte?
	GOTO	LOOK_BS1	;No? Then loop...
	MOVLW	05CH		;Yes? Then respond to
	SUBWF	rcreg,w		;w=rcreg-5CH
	BTFSS	zero		;Is '\' in rcreg?
	GOTO	LOOK_BS1	;No? Then loop..
	MOVF	rcreg,w		;w=rcreg
	MOVWF	txreg		;Send it back to host

LOOK_R	
	BTFSS	rcif		;Have we received a byte?
	GOTO	LOOK_R		;No? Then loop...
	MOVLW	052H		;Yes? Then is next char. an 'R'?
	SUBWF	rcreg,w		;w=rcreg-52H
	BTFSS	zero		;Is 'R' in rcreg?
	GOTO	LOOK_BS1	;No? Then loop...
	MOVF	rcreg,w		;w=rcreg
	MOVWF	txreg		;Send it back to host

LOOK_BS2
     	BTFSS	rcif		;Have we received a byte?
	GOTO	LOOK_BS2	;No? Then loop...
	MOVLW	05CH		;Yes? Then respond to
	SUBWF	rcreg,w		;w=rcreg-5CH
	BTFSS	zero		;Is '\' in rcreg?
	GOTO	LOOK_BS2	;No? Then loop..
	MOVF	rcreg,w		;w=rcreg
	MOVWF	txreg		;Send it back to host

LOOK_V
	BTFSS	rcif		;Have we received a byte?
	GOTO	LOOK_V		;No? Then loop...
	MOVLW	056H		;Yes? Then is next char. an 'V'?
	SUBWF	rcreg,w		;w=rcreg-56H
	BTFSS	zero		;Is 'V' in rcreg?
	GOTO	LOOK_T		;No? Try next char.
	MOVF	rcreg,w		;w=rcreg
	MOVWF	txreg		;Send it back to host
	GOTO	VOLT_PROG	;and get VOLTMETER

LOOK_T	
	MOVLW	054H		;Is next char. a 'T'?
	SUBWF	rcreg,w		;w=rcreg-54H
	BTFSS	zero		;Is 'T' in rcreg?
	GOTO	LOOK_C		;No? Try next char.
	MOVF	rcreg,w		;w=rcreg
	MOVWF	txreg		;Send it back to host
	GOTO	THERM_PROG	;and get THERMOMETER

LOOK_C	
	MOVLW	043H		;Is next char. a 'C'?
	SUBWF	rcreg,w		;w=rcreg-43H
	BTFSS	zero		;Is 'C' in rcreg?
	GOTO	LOOK_M		;No? Try next char.
	MOVF	rcreg,w		;w=rcreg
	MOVWF	txreg		;Send it back to host
	GOTO	COUNT_PROG	;and get COUNTER

LOOK_M	
	MOVLW	04DH		;Is next char. an 'M'?
	SUBWF	rcreg,w		;w=rcreg-4DH
	BTFSS	zero		;Is 'M' in rcreg?
	GOTO	LOOK_BS2	;No? Look for \ again.
	MOVF	rcreg,w		;w=rcreg
	MOVWF	txreg		;Send it back to host
	GOTO	MESS_MESS_WR	;and get MESSAGE


;*****************************************************************
;***INTERRUPT SERVICE ROUTINE***
;
;The interrupts used are	1.RX input on RB0/INT
;				2.Change on RB1
;
;***SAVE STATUS,W AND PCLATH REGISTERS IN RAM***
;
ISR     MOVWF   W_SAVE       	;Save w register
        SWAPF   status,w        ;Swop status to be saved in w
        CLRF    status          ;bank0, clears IRP,RP1,RP0
        MOVWF   S_SAVE          ;Save status register
        MOVF    pclath,w        ;Only if using pages 1,2&3
        MOVWF   P_SAVE  	;
        CLRF    pclath          ;Page 0
        BCF     irp             ;Return to bank0
        MOVF    fsr,w           ;Copy fsr to w
        MOVWF   FSR_S       	;Save file select register

;This routine is unimplimented at present, the user can add a function
;to be performed at this location. 

;***RETURN FROM INTERRUPT ROUTINE-RESTORE STATUS,W AND PCLATH***
;
        MOVF    P_SAVE,w    	;Move pclath into w
        MOVWF   pclath          ;Restore pclath register
        SWAPF   S_SAVE,w        ;Restore status
        MOVWF   status          ;without bit changes
        SWAPF   W_SAVE,f        ;Restore w register
        SWAPF   W_SAVE,w        ;without changing status bits
        RETFIE                  ;Return to main program            
;
;****************************************************************
	END
;*****************************************************************




