; file      : mess_1-1.inc
; author    : 
; date      : 14-SEP-1999
; purpose   : Display program Routines
; used by   : Library Routine
;
; Copyright (C) Lascar Electronics Ltd 1999
;
; This library is free software; you can redistribute it and/or
; modify it under the terms of the GNU Lesser General Public
; License as published by the Free Software Foundation; either
; version 2.1 of the License, or (at your option) any later version.
;
; This library is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; Lesser General Public License for more details.

; You should have received a copy of the GNU Lesser General Public
; License along with this library; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
; USA
;
;**************************************************************
;
;The routines within this file write and read messages to and from flash
;and displays those messages when required either static or scrolled.
;************************************************************************
;

CLR_DISPS2
	MOVLW	030H			;W=30H
	MOVWF	fsr			;FSR=30H
	MOVLW	019H			;W=19H
	MOVWF	TEMP3			;TEMP=19H
CD12	MOVLW	020H			;W=20H
	MOVWF	indf			;INDIRECT FILE=20H
	INCF	fsr,f			;INCREMENT FSR
	DECFSZ	TEMP3,f			;DECREMENT TEMP3. ZERO?
	GOTO	CD12			;NO, GOTO CD1
	RETURN				;YES, RETURN

;************************************************************************

CHK_MESS_LENGTH
	BCF	rb1			;bank0
	MOVLW	06H			;W=06H
	SUBWF	SP1,w			;W=SP1-06H
	BTFSC	carry			;WAS THERE A CARRY
	GOTO	DISP_SCROLL		;NO, GOTO SCROLL DISPLAY
					;DROP THROUGH
;************************************************************************

DISP_NORM2
	BCF	rb1			;bank0
	BCF	B_SEGS			;CLEAR LUT_B FLAG
	BCF	pclath,0		;First eighth
	BCF	pclath,1		;of page
	BCF	pclath,2
	MOVLW	030H			;W=30H
	MOVWF	DIGADR			;DIGADR=30H
	BSF	rp2			;page3
	CALL	ASC_SEGS		;CALL ASC_SEGS
	CLRF	SHIFTX			;LOAD COM1
	CALL	ASSEMBLE		;ASSEMBLE

	BSF	B_SEGS			;SET LUT_B FLAG
	CALL	ASC_SEGS		;CALL ASC_SEGS
	MOVLW	020H			;LOAD
	MOVWF	SHIFTX			;COM2
	CALL	ASSEMBLE		;ASSEMBLE
	CALL	DISPLAY_DELAY		;HOLD DISPLAY
	BCF	rp2			;page2
	RETURN

;************************************************************************

DISP_SCROLL
	BCF	rb1			;bank0
	BCF	B_SEGS			;CLEAR LUT_B FLAG
	BCF	pclath,0		;First eighth
	BCF	pclath,1		;of page
	BCF	pclath,2
	MOVLW	030H			;W=30H
	MOVWF	DIGADR			;DIGADR=30H

	MOVLW	032H			;ADD 32H 
	ADDWF	SP1,f			;TO SP1
	MOVLW	04H			;W=04H
	SUBWF	SP2,f			;SP2-4

DS1	BSF	rp2			;page3	
	CALL	ASC_SEGS		;CALL	ASC_SEGS
	CLRF	SHIFTX			;LOAD COM1
	CALL	ASSEMBLE		;ASSEMBLE

	BSF	B_SEGS			;SET LUT_B FLAG
	CALL	ASC_SEGS		;CALL ASC_SEGS
	MOVLW	020H			;LOAD
	MOVWF	SHIFTX			;COM2
	CALL	ASSEMBLE		;ASSEMBLE
	MOVLW	030H
	MOVWF	DS_DEL
	CALL	DELAY			;HOLD DISPLAY
	CALL	SCROLL_ONE		;SCROLL MESS ONCE TO LEFT
	BCF	rp2			;Page2
	DECFSZ	SP2,f
	GOTO	DS1
	BSF	rp2			;Page3
	CALL	DISPLAY_DELAY		;
	BCF	rp2			;Page2
	RETURN			
	
;************************************************************************
;************************************************************************
;READ PROGRAM ROUTINES 
READ_MESSA
	BCF	rb1			;bank0
	CLRF	SP1			;CLRF file SP1
	CLRF	SP2			;CLRF file SP2
	BCF	rb0			;set
	BSF	rb1			;bank2
	MOVLW	1EH			;W=1FH
	MOVWF	eeadrh			;eeadrh=1FH
	GOTO	READ_MESSC	
READ_MESSB
	BCF	rb1			;bank0
	CLRF	SP1			;CLRF file SP1
	CLRF	SP2			;CLRF file SP2
	BCF	rb0			;set
	BSF	rb1			;bank2
	MOVLW	1FH			;W=1FH
	MOVWF	eeadrh			;eeadrh=1FH
READ_MESSC
	MOVF	EEP2,w			;W=TEMP2
	MOVWF	eeadr			;eeadr=TEMP2
	MOVLW	030H			;W=30H
	MOVWF	fsr			;FSR=30H
READ_MESSD
	BSF	rp2			;Page3
	CALL	RD_FLASH		;READ FROM FLASH
	BCF	rp2			;Page2
	BTFSC	zero			;End of message? zero
	GOTO	CHK_MESS_LENGTH		;Yes, display message
	MOVWF	indf			;MOVE W INTO INDF
	BCF	rb0			;set
	BSF	rb1			;bank2
	INCF	eeadr,f			;NEXT FLASH ADDRESS
	INCF	fsr,f			;NEXT INDF
	BCF	rp2			;page2
	BCF	rb1			;bank0
	INCF	SP1,f			;Increment file SP1
	INCF	SP2,f			;Increment file SP2
	GOTO	READ_MESSD		;No, transfer next character
;************************************************************************

NEXT_MESS2
	BSF	rb1			;bank2
	INCF	EEP1,f			;INCREMENT MESS POINTER1 (bank2)
	MOVLW	01EH			;W=30 (DECIMAL)
	ADDWF	EEP2,f			;ADD 30 TO MESS POINTER2 (bank2)
	BCF	rb1			;bank0
	CALL	CLR_DISPS2		;clear the display registers
	RETURN

;************************************************************************
;MAIN PROGRAM (READ)
MESS_MESS_RD	
	CALL	CLR_DISPS2
	BCF	rb0			;set
	BSF	rb1			;bank2
	MOVLW	46H			;w=vector for MESSAGES
	MOVWF	EEP2			;EEP2 = MESSAGES
	CALL	READ_MESSB		;Display blank message	
MESS_PROG_RD
	CALL	CLR_DISPS2		;PUT SPACES IN ALL DISP FILES
	BSF	rb0			;Set bank1
	MOVLW	B'11111111'		;Set portd
	MOVWF	trisd			;as inputs
	BCF	rb0			;set
	BSF	rb1			;bank2
	MOVLW	01H			;W=01H
	MOVWF	EEP1			;EEP1=01H
	MOVLW	0H			;W=0H
	MOVWF	EEP2			;EEP2=0H	
	BCF	rb1			;bank0
	BTFSC	PI_O0			;IS PI_O0 (PORT D0) HIGH?
	CALL	READ_MESSA		;YES, READ MESSAGE
	NOP
	CALL	NEXT_MESS2		;NO, SET UP FOR NEXT MESS
	BTFSC	PI_O1			;IS PI_O1 HIGH?
	CALL	READ_MESSA		;YES, READ MESSAGE
	NOP
	CALL	NEXT_MESS2		;NO, SET UP FOR NEXT MESS
	BTFSC	PI_O2			;IS PI_O2 HIGH?
	CALL	READ_MESSA		;YES, READ MESSAGE
	NOP
	CALL	NEXT_MESS2		;NO, SET UP FOR NEXT MESS
	BTFSC	PI_O3			;IS PI_O3 HIGH?
	CALL	READ_MESSA		;YES, READ MESSAGE
	NOP
	CALL	NEXT_MESS2		;NO, SET UP FOR NEXT MESS
	BTFSC	PI_O4			;IS PI_O4 HIGH?
	CALL	READ_MESSA		;YES, READ MESSAGE
	NOP
	CALL	NEXT_MESS2		;NO, SET UP FOR NEXT MESSAGE
	BTFSC	PI_O5			;IS PI_O5 HIGH?
	CALL	READ_MESSA		;YES, READ MESSAGE
	NOP
	CALL	NEXT_MESS2		;NO, SET UP FOR NEXT MESSAGE
	BTFSC	PI_O6			;IS PI_06 HIGH?
	CALL	READ_MESSA		;YES, READ MESSAGE
	NOP
	CALL	NEXT_MESS2		;NO, SET UP FOR NEXT MESSAGE
	BTFSC	PI_O7			;IS PI_07 HIGH?
	CALL	READ_MESSA		;YES, READ MESSAGE
	MOVF	portd,w
	BTFSC	zero			;check for no messages selected [IRCN 0249]
	CALL	DISP_NORM2		;display spaces
	NOP
	GOTO	MESS_PROG_RD		;REPEAT PORT CHECKS

;************************************************************************
;************************************************************************
;WRITE PROGRAM ROUTINES 

WRT_MESS
	MOVLW	019H
	MOVWF	TEMP4
	CLRF	TEMP3			;TEMP3=0
	MOVF	TEMP2,w			;W=TEMP2
	BCF	rb0			;set
	BSF	rb1			;bank2
	MOVWF	eeadr			;eeadr=TEMP2
CLR_MESS_SPACE1
	BSF	rb1			;bank2
	MOVLW	020H			;SPACE
	MOVWF	eedata			;INTO INDF
	BSF	rp2			;page3
	CALL	WR_FLASH		;WRITE TO FLASH
	BCF	rp2			;page2	
	BSF	rb1
	INCF	eeadr,f
	BCF	rb1			;bank0
	DECFSZ	TEMP4,f			;???-1=0?
	GOTO	CLR_MESS_SPACE1		;Yes, GOTO CLR_MESS_SPACE1	
	MOVF	TEMP2,w			;W=TEMP2
	BSF	rb1			;bank2
	MOVWF	eeadr			;eeadr=TEMP2
	BCF	rb1			;Bank0
WM1	MOVF	rcreg,w			;w=rcreg
	MOVWF	txreg			;Send it back to host
	BCF	rb0			;set
	BSF	rb1			;bank2
	MOVWF	eedata
	BSF	rp2			;page3
	CALL	WR_FLASH		;Write to flash
	BCF	rp2			;page2
	NOP
	BCF	rb0			;set
	BSF	rb1			;bank2
	INCF	eeadr,f			;Next Address
	CLRF	status			;bank0
	DECF	TEMP4,f			;Decrement file TEMP4
WM2	BTFSS	rcif			;Have we received a byte?
	GOTO	WM2			;No? Then loop...
	MOVF	TEMP1,w			;Yes? W=TEMP1
	SUBWF	rcreg,w			;w=rcreg-TEMP1
	BTFSS	zero			;Is 'TEMP1' in rcreg?
	GOTO	WM1			;No, Then loop...

;The following piece of code places a nop (0000) into the next eeadr postion
	BSF	rb1			;bank2
	MOVLW	0H			;W=0
	MOVWF	eedata			;eedata=0
	BSF	rp2			;page3
	CALL	WR_FLASH		;Write to flash
	BCF	rp2			;page2
	RETURN				

;************************************************************************

NEXT_MESS
	INCF	TEMP1,f			;INCREMENT MESS POINTER
	MOVLW	1EH			;W=30 (DECIMAL)
	ADDWF	TEMP2,f			;ADD 30 TO TEMP2
	RETURN

;************************************************************************
;MAIN PROGRAM (WRITE)

MESS_MESS_WR	
	CALL	CLR_DISPS2
	BCF	rb0		;set
	BSF	rb1		;bank2
	MOVLW	46H		;w=vector for MESSAGES
	MOVWF	EEP2		;eeadr = MESSAGES
	CALL	READ_MESSB	;Display message

;Write to EEPROM
	BCF	rb0			;set
	BSF	rb1			;bank2
	MOVLW	0FFH			;W=0FFH 
	MOVWF	eeadr			;eeardr=0FFH
	MOVLW	03H			;W=03H
	MOVWF	eedata			;eedata=03H
	BSF	rp2			;page3
	CALL	WR_EEPROM		;read from EEPROM
	BCF	rp2			;page2
MESS_PROG_WR	
	MOVLW	01H			;MOVE 1ST MESS POINTER
	MOVWF	TEMP1			;INTO TEMP1
	MOVLW	00H			;MOVE 1E00H 
	MOVWF	TEMP2			;INTO W AND
	BCF	rb0			;set
	BSF	rb1			;bank2
	MOVLW	01EH			;MAKE IT THE
	MOVWF	eeadrh			;START ADDRESS
	BCF	rb1			;bank0
MESS_PROG_W2	
	BTFSS	rcif			;Have we received a byte?
	GOTO	MESS_PROG_W2		;No? Then loop...
	MOVF	TEMP1,w			;Yes? W=TEMP1
	SUBWF	rcreg,w			;w=rcreg-TEMP1
	BTFSS	zero			;Is 'TEMP1' in rcreg?
	GOTO	MESS_PROG_W2		;No? Then loop...
	MOVF	rcreg,w			;yes, w=rcreg
	MOVWF	txreg			;Send it back to host
MESS_PROG_W3	
	BTFSS	rcif			;Have we received a byte?
	GOTO	MESS_PROG_W3		;No? Then loop...
	MOVF	TEMP1,w			;Yes? W=TEMP1
	SUBWF	rcreg,w			;w=rcreg-TEMP1
	BTFSS	zero			;Is 'TEMP1' in rcreg?
	CALL	WRT_MESS		;NO, WRITE MESSAGE TO FLASH
	MOVF	rcreg,w			;yes, w=rcreg
	MOVWF	txreg			;Send it back to host
	CALL	NEXT_MESS		;YES, SET UP FOR NEXT MESS
	MOVLW	09H			;W=09H
	SUBWF	TEMP1,w			;W=TEMP1-08H
	BTFSS	zero			;WAS THE RESULT O?
	GOTO	MESS_PROG_W2		;NO, CHECK NEXT MESSAGE BOX.
LOOK_BS3
     	BTFSS	rcif			;Have we received a byte?
	GOTO	LOOK_BS3		;No? Then loop...
	MOVLW	05CH			;Yes? Then respond to
	SUBWF	rcreg,w			;w=rcreg-5CH
	BTFSS	zero			;Is '\' in rcreg?
	GOTO	LOOK_BS3		;No? Then loop..
	MOVF	rcreg,w			;w=rcreg
	MOVWF	txreg			;Send it back to host
LOOK_BS4
     	BTFSS	rcif			;Have we received a byte?
	GOTO	LOOK_BS4		;No? Then loop...
	MOVLW	05CH			;Yes? Then respond to
	SUBWF	rcreg,w			;w=rcreg-5CH
	BTFSS	zero			;Is '\' in rcreg?
	GOTO	LOOK_BS3		;No? Then loop..
	MOVF	rcreg,w			;w=rcreg
	MOVWF	txreg			;Send it back to host
	GOTO	MESS_PROG_RD		;YES, RETURN

;************************************************************************
	
	

