; file      : sfr_1-0.h
; author    : 
; date      : 14-SEP-1999
; purpose   : definitions of the Special Function Registers
; used by   : All the Lascar Modules
;
; Copyright (C) Lascar Electronics Ltd 1999
;
; This library is free software; you can redistribute it and/or
; modify it under the terms of the GNU Lesser General Public
; License as published by the Free Software Foundation; either
; version 2.1 of the License, or (at your option) any later version.
;
; This library is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; Lesser General Public License for more details.

; You should have received a copy of the GNU Lesser General Public
; License along with this library; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
; USA
;
;***************************************************************
;***PIC REGISTER EQUATES***

indf    equ     00H     ;Indirect addressing register
fsr     equ     04H     ;File select register
pcl     equ     02H     ;Program counter
status  equ     03H     ;Status register
pclath	equ	0AH	;Program counter upper 5bits
optreg	equ	081H	;Option register

pie1    equ     08CH    ;Interrupt enable register.(bank1)
pie2	equ	08DH	;Interrupt enable register.(bank1)
pir1    equ     0CH     ;Peripheral interrupt register1
pir2    equ     0DH     ;Peripheral interrupt register2
intcon  equ     0BH     ;Interrupt control register

rcreg   equ     01AH    ;Receive data register
rcsta   equ     018H    ;Receive comms. register
txreg	equ	019H	;Transmit data register
txsta   equ     098H    ;Transmit comms. register(bank1)
spbrg   equ     099H    ;Baud rate register.(bank1)
                       	;Note:- set SPBRG to 25 for 9600 baud.

adresl	equ	09EH	;Low values of A/D conversion
adresh	equ	01EH	;High values of A/D conversion
adcon0	equ	01FH	;A/D control register
adcon1	equ	09FH	;A/D input control register

eedata	equ	010CH	;EEPROM/FLASH data register(bank2)
eeadr	equ	010DH	;EEPROM/FLASH address register(bank2)
eedath	equ	010EH	;FLASH program memory high-data byte(bank2)
eeadrh	equ	010FH	;FLASH program memory high-address byte(bank2)
eecon1  equ     018CH   ;EEPROM/FLASH control register1(bank3)
eecon2  equ     018DH   ;EEPROM?FLASH control register2(bank3)

;***************************************************************
;***BIT EQUATES***

f       equ     1
w       equ     0

;***************************************************************
;***I/O EQUATES***
			;These registers control these ports!
porta   equ     05H     ;6ports/trisa/adcon1
portb   equ     06H     ;trisb/option(O/Ps to display driver [2 4 5])
portc   equ     07H     ;trisc(I/Ps from RX [7]; O/Ps to TX [6])
portd   equ     08H     ;trisd/trise,4(PSP mode)/pir1/pie1
porte   equ     09H     ;3ports/trise/adcon1

trisa	equ	085H	;Porta direction register
trisb	equ	086H	;Porta direction register
trisc	equ	087H	;Porta direction register
trisd	equ	088H	;Porta direction register
trise	equ	089H	;Porta direction register

;***************************************************************
