; file      : test_1-0.inc
; author    : 
; date      : 14-SEP-1999
; purpose   : Production test
; used by   : Library routine
;
; Copyright (C) Lascar Electronics Ltd 1999
;
; This library is free software; you can redistribute it and/or
; modify it under the terms of the GNU Lesser General Public
; License as published by the Free Software Foundation; either
; version 2.1 of the License, or (at your option) any later version.
;
; This library is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; Lesser General Public License for more details.

; You should have received a copy of the GNU Lesser General Public
; License along with this library; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
; USA
;
;**************************************************************
;
;The main shell program <MDM_1-x.asm> automatically defaults to this routine if the 
;MDM-1 module has not been previously configured and the RS232 is not being driven.
;This program requires access to the following files:-
;<sfr_1-x.inc>
;<defn_1-x.inc>
;<ltdd_1-x.inc>
;<luts_1-x.inc> 
;************************************************************************

;***Segment Test***
;Fetches the segment values from the <luts_1-x.inc> and
;moves them directly into the SHIFT registers for assembly... 
;
PROD_TEST	         	     	
	BCF	LUT_FLG		;Clear end of look-up table flag
        CLRF    PTR2	        ;into Look-up table pointer
SEGT_A  MOVF    PTR2,w   	;Value for next segment
        CALL    SEGTAB          ;Call segment 
	BTFSC	LUT_FLG		;Test for end of table
	GOTO	SEGT_B1		;If end then 'B' segments
        MOVWF   SHIFT5          ;Fill all
        MOVWF   SHIFT4          ;SHIFT
        MOVWF   SHIFT3          ;registers
        MOVWF   SHIFT2          ;with one
        MOVWF   SHIFT1          ;segment.
	CLRF	SHIFTX		;COM'A'
        CALL    ASSEMBLE        ;assemble 43 bit string <lltd_1-x.inc>
	CLRF	SHIFT5		;Clear
	CLRF	SHIFT4		;all
	CLRF	SHIFT3		;'B'
	CLRF	SHIFT2		;segments
	CLRF	SHIFT1		;
	MOVLW	020H		;COM'B'
	MOVWF	SHIFTX		;COM'B'
        CALL    ASSEMBLE        ;Assemble 43 bit string<lltd_1-x.inc>
	CALL	LED_OFF		;Program running indicator
        CALL    DISPLAY_DELAY   ;<lltd_1-5.inc>
	CALL	LED_ON		;Program running indicator
        INCF	PTR2,f		;LUT_PTR-1
        GOTO    SEGT_A          ;Fetch next 'A'segment
SEGT_B1	BCF	LUT_FLG		;Clear end of look-up table flag
        CLRF    PTR2         	;into Look-up table pointer
SEGT_B2	CLRF	SHIFT5		;Clear
	CLRF	SHIFT4		;all
	CLRF	SHIFT3		;'A'
	CLRF	SHIFT2		;segments
	CLRF	SHIFT1		;
	CLRF	SHIFTX		;COM'A'
        CALL    ASSEMBLE        ;assemble 43 bit string <lltd_1-x.inc>
	MOVF    PTR2,w   	;Value for next segment
 	CALL    SEGTAB          ;Call segment
	BTFSC	LUT_FLG		;Test for end of table
	GOTO	SEGT_B3		;If end then exit program 
        MOVWF   SHIFT5          ;Fill all
        MOVWF   SHIFT4          ;SHIFT
        MOVWF   SHIFT3          ;registers
        MOVWF   SHIFT2          ;with one
        MOVWF   SHIFT1          ;segment.
	MOVLW	020H		;COM'B'
	MOVWF	SHIFTX		;COM'B'
        CALL    ASSEMBLE        ;assemble 43 bit string <lltd_1-x.inc>
	CALL	LED_OFF		;Program running indicator
        CALL    DISPLAY_DELAY   ;<lltd_1-5.inc>
	CALL	LED_ON		;Program running indicator
        INCF	PTR2,f		;LUT_PTR-1
       	GOTO    SEGT_B2         ;Fetch next 'B'segment
SEGT_B3				;Next self-test routine...

;Test all segments...
SEG_TEST
	MOVLW	0FFH		;call all
	MOVWF	SHIFT1		;segments
	MOVWF	SHIFT2		;segments
	MOVWF	SHIFT3		;segments
	MOVWF	SHIFT4		;segments
	MOVWF	SHIFT5		;segments
	CLRF	SHIFTX		;segments
	BSF	rp3		;Set page3
	CALL	ASSEMBLE
	MOVLW	0FFH		;call all
	MOVWF	SHIFT1		;segments
	MOVWF	SHIFT2		;segments
	MOVWF	SHIFT3		;segments
	MOVWF	SHIFT4		;segments
	MOVWF	SHIFT5		;segments
	MOVLW	020H		;COM2
	MOVWF	SHIFTX		;Load register
	CALL	ASSEMBLE	;Assemble 43bit string
	CALL	LED_OFF		;Program running indicator
	CALL 	DISPLAY_DELAY	;Hold display
	CALL	LED_ON		;Program running indicator
;************************************************************************
;***PORT TEST***
;Tests all port bits except RB<2,4,5>, driving a series of LEDs.
;
;Set up the ports
	BSF	rb0		;bank1
	MOVLW	06H		;Set porta and porte
	MOVWF	adcon1		;digital
	MOVLW	B'00000100'	;set in/outputs for
	MOVWF	trisa		;porta
	MOVLW	0H		;set output ports...
	MOVWF	trisb		;portb
	MOVWF	trisc		;portc
	MOVWF	trisd		;portd
	MOVWF	trise		;porte
	BCF	rb0		;bank0
	BCF	carry		;clear carry flag
;Set first pin high
	MOVLW	01H		;move 1 into...
	MOVWF	porta		;porta
	MOVWF	portb		;portb
	MOVWF	portc		;portc
	MOVWF	portd		;portd
	MOVWF	porte		;porte
	MOVLW	26H		;move delay length
	MOVWF	DS_DEL		;into DS_DEL
	CALL	DELAY		;hold
;Set second pin high	
	RLF	porta,f		;next pin on porta
	RLF	portb,f		;next pin on portb
	RLF	portc,f		;next pin on portc
	RLF	portd,f		;next pin on portd
	RLF	porte,f		;next pin on porte
	CALL	DELAY		;hold
;Set third pin high
	RLF	porta,f		;next pin on porta
	RLF	portb,f		;next pin on portb
	RLF	portc,f		;next pin on portc
	RLF	portd,f		;next pin on portd
	RLF	porte,f		;next pin on porte
	CALL	DELAY		;hold
;Set fourth pin high	
	RLF	porta,f		;next pin on porta
	RLF	portb,f		;next pin on portb
	RLF	portc,f		;next pin on portc
	RLF	portd,f		;next pin on portd
	CLRF	porte		;clear porte
	CALL	DELAY		;hold
;Set fith pin high
	RLF	porta,f		;next pin on porta
	RLF	portb,f		;next pin on portb
	RLF	portc,f		;next pin on portc
	RLF	portd,f		;next pin on portd
	CALL	DELAY		;hold
;Set sixth pin high
	RLF	porta,f		;next pin on porta
	RLF	portb,f		;next pin on portb
	RLF	portc,f		;next pin on portc
	RLF	portd,f		;next pin on portd
	CALL	DELAY		;hold
;Set seventh pin high
	CLRF	porta		;clear porta
	RLF	portb,f		;next pin on portb
	RLF	portc,f		;next pin on portc
	RLF	portd,f		;next pin on portd
	CALL	DELAY		;hold
;Set eighth pin high	
	RLF	portb,f		;next pin on portb
	RLF	portc,f		;next pin on portc
	RLF	portd,f		;next pin on portd
	CALL	DELAY		;hold
;************************************************************************
SELF_TEST
;Test all segments...
	MOVLW	0FFH		;call all
	MOVWF	SHIFT1		;segments
	MOVWF	SHIFT2		;segments
	MOVWF	SHIFT3		;segments
	MOVWF	SHIFT4		;segments
	MOVWF	SHIFT5		;segments
	CLRF	SHIFTX		;segments
	CALL	ASSEMBLE
	MOVLW	0FFH		;call all
	MOVWF	SHIFT1		;segments
	MOVWF	SHIFT2		;segments
	MOVWF	SHIFT3		;segments
	MOVWF	SHIFT4		;segments
	MOVWF	SHIFT5		;segments
	MOVLW	020H		;COM2
	MOVWF	SHIFTX		;Load register
	CALL	ASSEMBLE	;Assemble 43bit string
	CALL	LED_OFF		;Program running indicator
	CALL 	DISPLAY_DELAY	;Hold display
	CALL	LED_ON		;Program running indicator

;Test message display drivers
	BCF	rp2		;set page2
	CALL	CLR_DISPS2
	BCF	rb0		;set
	BSF	rb1		;bank2
	MOVLW	00H		;w=vector for ALLOK
	MOVWF	EEP2		;EEP2 = ALLOK
	CALL	READ_MESSB	;Display message

	CALL	CLR_DISPS2
	BCF	rb0		;set
	BSF	rb1		;bank2
	MOVLW	4CH		;w=vector for CONFIG
	MOVWF	EEP2		;EEP2 = CONFIG
	CALL	READ_MESSB	;Display message
	BSF	rp2		;set page3
	GOTO	SELF_TEST
		
;************************************************************************

