; file      : thrm_1-0.h
; author    : 
; date      : 14-SEP-1999
; purpose   : Functionality of a temperature meter
; used by   : Library routine
;
; Copyright (C) Lascar Electronics Ltd 1999
;
; This library is free software; you can redistribute it and/or
; modify it under the terms of the GNU Lesser General Public
; License as published by the Free Software Foundation; either
; version 2.1 of the License, or (at your option) any later version.
;
; This library is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; Lesser General Public License for more details.

; You should have received a copy of the GNU Lesser General Public
; License along with this library; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
; USA
;
;**************************************************************
;
;Used with any two terminal analogue output sensor which
;outputs between 2 and 50mV per degree C or F. 
;
;EDITING THIS FILE allows the user to alter the funtionality of the LASCAR MDM-1 display
;module.  The digit order is 5 4 3 2 1...ie the display reads 99.9 C or 999.9F
;NOTE: All inputs to be in Centigrade, calling 'F' or 'K' converts the centigrade results.
;	       DIGIT
;	      POSITION
;***********************************************************************
UNTT	equ 'C'	;1	;The meter units are set to CENTIGRADE	
			;edit this to 'F' for FAHRENHEIT, 'K' for ABSOLUTE
;***********************************************************************
MODT	equ 0	;2	;This default places a degree sybol in digit position 2
			;Edit to a 1, to use 4 digits for the temperature display
;***********************************************************************
OPT1   	equ 4	;units	;Edit this number to match the reciprocal of the output per degreeC 
OPT2   	equ 4	;tens	;from the sensor being used. This default is for use with the 
OPT3   	equ 0	;hun's	;AD22100K which outputs 28mV per degree C. Variations 
			;in this value will affect the upper display value (SPAN).
			; 1 / 0.028 = 36
;***********************************************************************
			;Reference voltage:- default=5.00volts
RFT1 	equ 0	;Hun'ths;The internal ADC reference voltage uses Vdd (+5.00v)
RFT2 	equ 0	;Tenths	;To use an external reference, insert the new reference voltage
RFT3 	equ 5	;Units	;in the range REF = 1.0 to 5.0
			;The external reference should be connected to porta,3
;***********************************************************************
CT1   	equ 8	;Hun'ths;OFFSET - Edit this number to adjust the lower display value
CT2   	equ 3	;Tenths	;where the sensor has an O/P at zero degrees.
CT3   	equ 1	;Units
CTP   	equ 0	;(+/-)	;Offset polarity, for a negative offset put CTN to 0 
;***********************************************************************
			;digit position modifier
DPMT 	equ 2		;1=default position (LSD dig2)
			;2=position (LSD dig3)	 		
;***********************************************************************
ZST   	equ 0   	;Zero suppression is off...
			;Set this value to 1 for leading zero suppression.
;***********************************************************************
   			;These numbers specify the HIGH WARNING level as 36 
WT3H   	equ 5    	;at which a warning message will be displayed 
WT4H   	equ 3    	;if the display exceeds this value.
WT5H   	equ 0	   	;Change these numbers to the required high warning level 
NTWH   	equ 1		;Change to 0 for no high warning
;***********************************************************************	
		    	;This number specifies the LOW WARNING level as 17 
WT3L  	equ 0    	;at which a warning message will be displayed if the
WT4L  	equ 1    	;display falls below this value. 
WT5L  	equ 0 		;Change these numbers to the required low warning level 
NTWL  	equ 1		;Change to 0 for no low warning
;***********************************************************************				 			
	    		;These numbers specify the HIGH ALARM level
AT3H  	equ 0   	;as 90 at which an alarm will be triggered
AT4H  	equ 4   	;if the display exceeds this value. 
AT5H  	equ 0    	;Change these numbers to the required high alarm level
NTAH  	equ 1		;Change to 0 for no high alarm
;***********************************************************************
			;This number specifies the LOW ALARM level as 5	
AT3L  	equ 5  		;at which an alarm will be triggered if the display 
AT4L  	equ 0   	;falls below this value.
AT5L  	equ 0   	;Change these numbers to the required low alarm level
NTAL  	equ 1		;Change to 0 for no low alarm  		
;*********************************************************************** 
			;DUE TO THE SIZE OF THE ADC THE MAXIMUMUM ACCURACY IS 1024 UNITS. 
			;IF MORE ACCURACY IS REQUIRED AN EXTERNAL ADC SHOULD BE FITTED.
			;SEE THE FILE FOR INTERFACING WITH EXTERNAL ADC'S.
;***********************************************************************
DDT  	equ 35		;Display refresh time...
			;Set between 25 and 45 
			;The larger the number the longer the display holds.
;***********************************************************************
DMT  	equ 35  	;Message display hold time...
			;Set between 25 and 45 
			;The larger the number the longer the message is displayed.
;***********************************************************************
;NOTE:			;This program uses the data message file <mess_1-A> to activate the
			;messages 'TooHI' 'TooLo' 'HIALA' and 'LoALA' if the alarms are set.
;*************************************************************************************	

