; file      : thrm_1-0.inc
; author    : 
; date      : 14-SEP-1999
; purpose   : 
; used by   : Library routine
;
; Copyright (C) Lascar Electronics Ltd 1999
;
; This library is free software; you can redistribute it and/or
; modify it under the terms of the GNU Lesser General Public
; License as published by the Free Software Foundation; either
; version 2.1 of the License, or (at your option) any later version.
;
; This library is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; Lesser General Public License for more details.

; You should have received a copy of the GNU Lesser General Public
; License along with this library; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
; USA
;
;**************************************************************
;
;This routine uses readings taken from porta,1 of the 16F877 PICmicro (R). 
;A/D conversion is done by the onchip 10bit A/D converter. The readings are stored
;in the adresh and adresl registers.

;***DISPLAY TEMP MESSAGE***

THERM_PROG
	CALL	CLR_DISPS2
	BCF	rb0		;set
	BSF	rb1		;bank2
	MOVLW	34H		;w=vector for THERM
	MOVWF	EEP2		;EEP2 = THERM
	CALL	READ_MESSB	;Display message

;***STORE MODULE CONFIGURATION IN EEPROM***
;For thermometer the value 01h is stored to address 0ffh
	BCF	rb0		;set
	BSF	rb1		;bank2
	MOVLW	0FFH		;W=0FFH 
	MOVWF	eeadr		;eeardr=0FFH
	MOVLW	01H		;W=01H
	MOVWF	eedata		;eedata=01H
	BSF	rp2		;page3
	CALL	WR_EEPROM	;read from EEPROM
	BCF	rp2		;page2	

;***SET UP PORTB FOR ALARM AND WARNING OUTPUTS***
	CLRF	portb		;on portb
	BSF	rb0		;bank1
	MOVLW	b'00000000' 	;Set outputs for warning
	MOVWF	trisb		;and alarm messages on portb
	BCF	rb0		;bank0
	
;***********************************************************************
;Clear flags
	CLRF	FLAG2		;Temperature scale flag
	CLRF	DPM		;Digit position modifier
;***********************************************************************
;***ANALOGUE TO DIGITAL CONVERSION***

ADC_THERM	
	BSF	adcon0,0	;Turn-on A/D
	BSF	rb0	    	;Select bank1
	BSF	adcon1,7	;set adfm result format justify right
	MOVLW	0FFH	 	;and set-up all 8 inputs as analogue
				;with Vdd and Vss as + & - references.
	MOVWF	trisa		;RA1/AN1 (bank1)
	CLRF	status		;bank0
	MOVLW	b'01001001' 	;Fosc=RC/bit7=1/bit6=1;bit4=1 for RA1/AN1		
	MOVWF	adcon0		;select analogue inputs,start ADC,bank0	
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	BSF	adcon0,2	;Start conversion				
T_DONE	BTFSC	adcon0,2   	;Conversion finished?go/done=0
	GOTO	T_DONE	        ;No? Then continue
	BCF	adcon0,0	;Turn-off A/D
;***********************************************************************
;***MAIN PROGRAM STARTS HERE***
;Temperature=[((NADCxVREF)/1024)-VOFFSET]xROPD
;The following three variables can be altered in the header.
;VREF=Supply voltage 
;VOFFSET=Output of sensor @ 0 degreeC
;ROPD=The reciprocal of the sensor output per degreeC
;***********************************************************************
;Mathmatic routine (1) - NADCxVREF
;Move the VREF values into the multiplicand registers
	MOVLW	RFT1		;w=RFT1
	MOVWF	BCD1		;BCD1=RFT1
	MOVLW	RFT2		;w=RFT2
	MOVWF	BCD2		;BCD2=RFT2
	MOVLW	RFT3		;w=RFT3
	MOVWF	BCD3		;BCD3=RFT3
	CLRF	BCD4		;
	CLRF	BCD5		;
	BSF	rp2		;page3
	CALL	BCD_BINARY	;<math_1-A.inc>
;Values returned in ACC1\2\3
	MOVF	ACC1,w		;
	MOVWF	MCNDL		;
	MOVF	ACC2,w		;
	MOVWF	MCNDH		;	
;Put the NADC values into the multiplier registers
	BSF	rb0		;bank1
	MOVF	adresl,w	;w=adresl
	BCF	rb0		;bank0
	MOVWF	MPLRL		;MPLRL=adresl	 
	MOVF	adresh,w	;w=adresh
	MOVWF	MPLRH		;MPLRH=adresh
	CALL	MULTIPLICATION	;<math_1-A.inc>
;Product returned in ACC1\2\3
;***********************************************************************
;Mathmatic routine (2) - (NADCxVREF)/1024
	MOVF	ACC1,w		;
	MOVWF	DVD1		;
	MOVF	ACC2,w		;
	MOVWF	DVD2		;
	MOVF	ACC3,w		;
	MOVWF	DVD3		;
;Divide by ADC accuracy		;
	CLRF	DVRL		;
	MOVLW	04H		;1024
	MOVWF	DVRH		;
	CALL	DIVISION	;<math_1-A.inc>
;Product returned in ACC1\2\3
;***********************************************************************
;Mathmatic routine (3) - ((NADCxVREF)/1024)-VOFFSET
	MOVF	ACC1,w		;w=ACC1
	MOVWF	ADD1L		;SUB2L=ACC1
	MOVF	ACC2,w		;w=ACC2
	MOVWF	ADD1H		;SUB2H=ACC1
;Move the VOFFSET values into the multiplicand registers
	MOVLW	CT1		;w=CT1
	MOVWF	BCD1		;BCD1=CT1
	MOVLW	CT2		;w=CT2
	MOVWF	BCD2		;BCD2=CT2
	MOVLW	CT3		;w=CT3
	MOVWF	BCD3		;BCD3=CT3
	CLRF	BCD4		;
	CLRF	BCD5		;
	CALL	BCD_BINARY	;<math_1-A.inc>
;Values returned in ACC1\2\3
	MOVF	ACC1,w		;w=ACC1
	MOVWF	ADD2L		;SUB2L=ACC1
	MOVF	ACC2,w		;w=ACC2
	MOVWF	ADD2H		;SUB2H=ACC1
	MOVLW	CTP		;Get offset polarity
	MOVWF	TEMP1		;
	BTFSS	TEMP1,0		;Is it clear (negative)?
	BSF	NEGF2		;Yes, then subtract CT
	BCF	NEGF1		;
	CALL	ADDITION	;<math_1-A.inc>
;Values returned in ACC1\2\3
;***********************************************************************
;Mathmatic routine (4) - [((NADCxVREF)/1024)-VOFFSET]xROPD
	MOVF	ACC1,w		;
	MOVWF	MCNDL		;
	MOVF	ACC2,w		;
	MOVWF	MCNDH		;
;Move the VREF values into the multiplicand registers
	MOVLW	OPT1		;w=OPT1
	MOVWF	BCD1		;BCD1=OPT1
	MOVLW	OPT2		;w=OPT2
	MOVWF	BCD2		;BCD2=OPT2
	MOVLW	OPT3		;w=OPT3
	MOVWF	BCD3		;BCD3=OPT3
	CLRF	BCD4		;
	CLRF	BCD5		;
        CALL    BCD_BINARY      ;<math_1-x.inc>
;Values returned in ACC1\2\3
	MOVF	ACC1,w		;
	MOVWF	MPLRL		;
	MOVF	ACC2,w		;
	MOVWF	MPLRH		;	
        CALL    MULTIPLICATION  ;<math_1-x.inc>
;***********************************************************************
;Mathmatic routine (5) - /by 100 for header correction
	MOVF	ACC1,w		;
	MOVWF	DVD1		;
	MOVF	ACC2,w		;
	MOVWF	DVD2		;
	MOVF	ACC3,w		;
	MOVWF	DVD3		;
	CLRF	DVRH		;
	MOVLW	64H		;100
	MOVWF	DVRL		;
        CALL    DIVISION        ;<math_1-x.inc>
;Product returned in ACC1\2\3
	BCF	rp2		;page2
;***********************************************************************
;Test for RD6 Hi (Fahrenheit scale)
	BTFSC	portd,6		;Fahrenheit?
	GOTO	FAHRT		;
;Test for RD7 Hi (Kelvin scale)
	BTFSC	portd,7		;Fahrenheit?
	GOTO	KELVIN		;
;***********************************************************************
;Now test for header configurations
	MOVLW	UNTT		;What units
	SUBLW	046H		;'F'?
	BTFSC	zero		;
	GOTO	FAHRT		;Fahrenheit routine
	MOVLW	UNTT		;What units
	SUBLW	04BH		;'K'?
	BTFSC	zero		;
	GOTO	KELVIN		;
	GOTO	B_BCD_CONV	;otherwise stay with centigrade...
;***********************************************************************
;Conversion to Fahrenheit=x(9/5)+32
;Move value in ACC1\2\3 into the multiplicand registers...
FAHRT	;BSF	FLAG2,2		;Fahrenheit flag
	MOVF	ACC1,w		;w=ACC1
	MOVWF	MCNDL		;MCNDL=ACC1	
	MOVF	ACC2,w		;w=ACC2
	MOVWF	MCNDH		;MCNDL=ACC2
;
	MOVLW	09H		;9	
	MOVWF	MPLRL		;x9
	CLRF	MPLRH		;0
	BSF	rp2		;page3
	CALL	MULTIPLICATION	;CENTx9
;Values returned in ACC1\2\3
;Move these values into the dividend registers
	MOVF	ACC1,w		;w=ACC1
	MOVWF	DVD1		;DVD1=ACC1	
	MOVF	ACC2,w		;w=ACC2
	MOVWF	DVD2		;DVD2=ACC2
	MOVF	ACC3,w		;w=ACC2
	MOVWF	DVD3		;DVD3=ACC3
;
	MOVLW	05H		;5	
	MOVWF	DVRL		;5
	CLRF	DVRH		;0
	CALL	DIVISION	;(CENTx9)/5	
;Values returned in ACC1\2\3
;Move these values into the addition registers
	MOVF	ACC1,w		;w=ACC1
	MOVWF	ADD1L		;ADD1L=ACC1	
	MOVF	ACC2,w		;w=ACC2
	MOVWF	ADD1H		;ADD1H=ACC2
;
	MOVLW	020H		;dec32	
	MOVWF	ADD2L		;
	CLRF	ADD2H		;0
	CALL	ADDITION	;[(CENTx9)/5]+32
	BCF	rp2		;page2
;Values returned in ACC1\2\3
	GOTO	B_BCD_CONV
;***********************************************************************
;Conversion to KELVIN scale=CENT+273
;Move value in ACC1\2\3 into the addition registers...
;Values returned in ACC1\2\3
;Move these values into the addition registers
KELVIN	;BSF	FLAG2,3		;KELVIN flag
	MOVF	ACC1,w		;w=ACC1
	MOVWF	ADD1L		;ADD1L=ACC1	
	MOVF	ACC2,w		;w=ACC2
	MOVWF	ADD1H		;ADD1H=ACC2
;
	MOVLW	011H		;dec273	
	MOVWF	ADD2L		;
	MOVLW	01H		;	
	MOVWF	ADD2H		;
	BSF	rp2		;page3
	CALL	ADDITION	;CENT+273
;Values returned in ACC1\2\3
;***********************************************************************
B_BCD_CONV			;Re-convert to BCD
	BSF	rp2		;page3	
	CALL	BINARY_BCD	;
	BCF	rp2		;page2
;Converts Binary to Binary coded decimal.
;BCD code returned in registers BCD1\2\3\4\5
;Are warnings and alarms required?
	       
	BTFSC	portd,0		;Is message pin28 Hi?				
	GOTO	DISPLAY_T	;No? Then skip message routines

;Values returned in ACC1\2\3
	BSF	rp2		;page3
	CALL	BINARY_BCD	;Yes? Then test for warning/alarm values...
	BCF	rp2		;page2
	MOVLW	DMT		;Get message
	MOVWF	DS_DEL		;display time.	

;***TEST FOR ALARMS AND WARNINGS***

HI_ALARM
	BCF	zero
	MOVLW	NTAH		;No Hi-ALARM?
	BTFSC	zero		;If zero then skip this ALARM
	GOTO	HI_warning	;to...	
	MOVLW	AT5H		;Get digit5 Hi-ALARM value
	SUBWF	BCD3,w		;actual-warning
	BTFSC	zero		;Test for =,if= then test AT4H 
	GOTO	AT4H1		;Check next bytes
	BTFSC	carry		;Test for -ve answer
	GOTO	HI_A
	GOTO	HI_warning
AT4H1	MOVLW	AT4H		;Get digit4 Hi-ALARM value
	SUBWF	BCD2,w		;actual-warning
	BTFSC	zero		;Test for =,if= then test AT3H 
	GOTO	AT3H1		;Check next bytes
	BTFSC	carry		;Test for -ve answer
	GOTO	HI_A
	GOTO	HI_warning
AT3H1	MOVLW	AT3H		;Get digit3 Hi-ALARM value
	SUBWF	BCD1,w		;actual-warning
	BTFSC	carry		;if -ve, then no carry
	GOTO	HI_A		;Then display HI-ALM
	BCF	portb,7		;else clear alarm/warning outputs

HI_warning
	BCF	zero
	MOVLW	NTWH		;No Hi-warning?
	BTFSC	zero		;If zero then skip this warning
	GOTO	Lo_ALARM	;to...	
	MOVLW	WT5H		;Get digit5 HI-warning value
	SUBWF	BCD3,w		;actual-warning
	BTFSC	zero		;Test for =,if= then test WT4H 
	GOTO	WT4H1		;Check next bytes
	BTFSC	carry		;Test for -ve answer
	GOTO	HI_W
	GOTO	Lo_ALARM
WT4H1	MOVLW	WT4H		;Get digit4 HI-warning value
	SUBWF	BCD2,w		;actual-warning
	BTFSC	zero		;Test for =,if= then test WT3H 
	GOTO	WT3H1		;Check next bytes
	BTFSC	carry		;Test for -ve answer
	GOTO	HI_W
	GOTO	Lo_ALARM
WT3H1	MOVLW	WT3H		;Get digit3 HI-warning value
	SUBWF	BCD1,w		;actual-warning
	BTFSC	carry		;if -ve, then no carry
	GOTO	HI_W		;Then display Too-HI
	BCF	portb,1		;else clear alarm/warning outputs

Lo_ALARM
	BCF	zero
	MOVLW	NTAL		;No Lo-ALARM?
	BTFSC	zero		;If zero then skip this ALARM
	GOTO	Lo_warning	;Display voltage	
	MOVLW	AT5L		;Get digit5 Lo-ALARM value
	SUBWF	BCD3,w		;actual-warning
	BTFSC	zero		;Test for =,if= then test AT4H 
	GOTO	AT4L1		;Check next bytes
	BTFSS	carry		;Test for -ve answer
	GOTO	Lo_A
	GOTO	Lo_warning
AT4L1	MOVLW	AT4L		;Get digit4 Lo-ALARM value
	SUBWF	BCD2,w		;actual-warning
	BTFSC	zero		;Test for =,if= then test AT3H 
	GOTO	AT3L1		;Check next bytes
	BTFSS	carry		;Test for -ve answer
	GOTO	Lo_A
	GOTO	Lo_warning
AT3L1	MOVLW	AT3L		;Get digit3 Lo-ALARM value
	SUBWF	BCD1,w		;actual-warning
	BTFSS	carry		;if -ve, then no carry
	GOTO	Lo_A		;Then display LO-ALM
	BCF	portb,6		;else clear alarm/warning outputs

Lo_warning
	BCF	zero
	MOVLW	NTWL		;No Lo-warning?
	BTFSC	zero		;If zero then skip this warning
	GOTO	DISPLAY_T	;to...		
	MOVLW	WT5L		;Get digit5 Lo-warning value
	SUBWF	BCD3,w		;actual-warning
	BTFSC	zero		;Test for =,if= then test WT4L 
	GOTO	WT4L1		;Check next bytes
	BTFSS	carry		;Test for -ve answer
	GOTO	Lo_W
	GOTO	DISPLAY_T
WT4L1	MOVLW	WT4L		;Get digit4 Lo-warning value
	SUBWF	BCD2,w		;actual-warning
	BTFSC	zero		;Test for =,if= then test WT3L 
	GOTO	WT3L1		;Check next bytes
	BTFSS	carry		;Test for -ve answer
	GOTO	Lo_W
	GOTO	DISPLAY_T
WT3L1	MOVLW	WT3L		;Get digit3 LO-warning value
	SUBWF	BCD1,w		;actual-warning
	BTFSS	carry		;if -ve, then no carry
	GOTO	Lo_W		;Then display Too-LO
	BCF	portb,0		;else clear alarm/warning outputs
	GOTO	DISPLAY_T

HI_W    CALL    TOO_HI          ;<mess_1-x.inc>
	GOTO	DISPLAY_T	;Display voltage
Lo_W    CALL    TOO_LO          ;<mess_1-x.inc>
	GOTO	DISPLAY_T	;Display voltage
HI_A    CALL    HI_ALM          ;<mess_1-x.inc>
	GOTO	DISPLAY_T	;Display voltage	
Lo_A    CALL    LO_ALM          ;<mess_1-x.inc>
	GOTO	DISPLAY_T	;Display voltage	

;***IMPLEMENT CORRECT ANNUNCIATOR***

D_SYMA	MOVLW	0E2H		;Degree symbol
	MOVWF	SHIFT2		;in position 2
	GOTO	DIST1A		;Test for scale
F_SYMA	MOVLW	066H		;'F' in position 1
	MOVWF	SHIFT1		;
	GOTO	DIST2A		;
K_SYMA	MOVLW	026H		;'K' in position 1
	MOVWF	SHIFT1		;
	GOTO	DIST2A		;
D_SYMB	MOVLW	02H		;Degree symbol
	MOVWF	SHIFT2		;in position 2
	GOTO	DIST1B		;
K_SYMB	MOVLW	090H		;'K' in position 1
	MOVWF	SHIFT1		;
	GOTO	DIST2B		;

;***CHECK FOR DIGIT POSITION (PINS)***

DIGIT_POST
	BTFSS	portd,4		;check portd,4
	GOTO	DIG_POS_HDRT	;check header 
	MOVLW	DPMT		;
	MOVWF	DPM		;shift the digit
	RETURN			;position

;***CHECK FOR DIGIT POSITION (HEADER)***

DIG_POS_HDRT
	MOVLW	DPMT
	MOVWF	DPM
	RETURN
		
;***IMPLEMENT NEGATIVE SIGN IN SHIFT5 POSITION***

NEGSHIFT5
	MOVLW	02H
	MOVWF	SHIFT5
	RETURN

;***DISPLAY THE RESULTS <ltdd_1-0.inc>***

DISPLAY_T	
	CALL	DIGIT_POST	;check for digit position
	BCF	B_SEGS		;Clear B_SEGS flag
	BSF	rp2		;page3		
	CALL 	NUM_SEGS	;Fetch display segments (A)
	BCF	rp2		;page2	
;Gets the display segment values and transfers them to the 
;SHIFT registers to build the 43 bit display word...
;Set-up THERMOMETER display header parameters (A)...
	MOVLW	MODT		;Degree symbol?
	MOVWF	TEMP1
	BTFSS	TEMP1,0		;
	GOTO	D_SYMA		;Yes?
DIST1A	BTFSC	FLAG2,2		;Fahrenheit flag
	GOTO	F_SYMA		;
	BTFSC	FLAG2,3		;Kelvin flag
	GOTO	K_SYMA		;Yes?
;Test external portd overides...
	BTFSC	portd,5		;Degree symbol?
	GOTO	D_SYMA		;
	BTFSC	portd,6		;'F' in digit position1
	GOTO	F_SYMA		;
	BTFSC	portd,7		;'K' in digit position1
	GOTO	K_SYMA		;
	MOVLW	06CH		;'C' segments(A)
	MOVWF	SHIFT1		;
DIST2A	CLRF	SHIFTX		;COM1
	BTFSC	NEGF1		;-VE answer?
	CALL	NEGSHIFT5
	BSF	rp2		;page3	
	CALL	ASSEMBLE	;Assemble 43 bit 'A' word
	BSF	B_SEGS		;set LUT 'B' flag
	BCF	pclath,1
	CALL 	NUM_SEGS	;Fetch display segments 'B'
	BCF	rp2		;page2	
;Set-up THERMOMETER parameters (B)..
	MOVLW	MODT		;Degree symbol?
	MOVWF	TEMP1
	BTFSS	TEMP1,0		;
	GOTO	D_SYMB		;Yes?
;Test external portd overides...
	BTFSC	portd,5		;Degree symbol?
	GOTO	D_SYMB		;
DIST1B	BTFSC	portd,7		;'K' in digit position1
	GOTO	K_SYMB		;
	CLRF	SHIFT1		;
DIST2B	MOVLW	020H		;COM2
	MOVWF	SHIFTX		;bit
	BTFSC	NEGF1		;-VE answer?
	CALL	NEGSHIFT5
	BSF	rp2		;page3	
	CALL	ASSEMBLE	;Assemble 43 bit 'B' word
	CALL	LED_OFF		;
	MOVLW	DDT		;Get display delay
	MOVWF	DS_DEL
	CALL	DELAY		;
	CALL	LED_ON		;
	BCF	rp2		;page2	
	GOTO	ADC_THERM	;
;*****************************************************************************




