; file      : volt_1-1.h
; author    : 
; date      : 14-SEP-1999
; purpose   : Votmeter variables
; used by   : Library routine
;
; Copyright (C) Lascar Electronics Ltd 1999
;
; This library is free software; you can redistribute it and/or
; modify it under the terms of the GNU Lesser General Public
; License as published by the Free Software Foundation; either
; version 2.1 of the License, or (at your option) any later version.
;
; This library is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; Lesser General Public License for more details.

; You should have received a copy of the GNU Lesser General Public
; License along with this library; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
; USA
;
;**************************************************************
;
;THIS FILE IS USED TO DETERMINE THE FUNCTIONALITY 0F A VOLTMETER.
;
;EDITING THIS FILE allows the user to alter the funtionality of the LASCAR EP-1 display
;module.  The digit order is 5 4 3 2 1...ie the display reads 05.00V or 99.9Kv...etc
;with the V's in digit position 1and the DP in position 3.
;
;With the installed firmware and using the +5v power rail as the reference the maximum 
;actual input acceptable at the input terminals is 5.0volts.
;To scale the meter, set the desired display reading (FSV) required at this voltage
;To measure higher voltages, external scaling resistors must be fitted...
;NOTES: 1. Voltmeter readings are likely to be inaccurate below +0.3 and above +4.7volts.
;	2. This volmeter cannot directly measure negative voltages.

;	      DIGIT
;	     POSITION
;****************************************************************	
FSV2 	equ  0    ; 2 	;Required display reading (SPAN):-
FSV3  	equ  8    ; 3  	;These 'FSV' equate values shown will display 4.67V at an FSI of 4.67volts.
FSV4  	equ  4    ; 4 	;Adjust these values in each position as required.
FSV5  	equ  0    ; 5	;A - (negative) sign can be placed in this position if desired.
;****************************************************************
MV2  	equ  0    ;(0.V);If the input voltage for the above display value is not the 5volts 
MV3  	equ  5    ;(V)	;maximum, then change the MV equate to the required voltage.
;****************************************************************
CV2  	equ  0    ; 2	;OFFSET:-
CV3  	equ  0    ; 3   ;These 'CV' equate values shown will display 0000 at zero input
CV4  	equ  0    ; 4	;voltage, adjust these values as required.		
CVP  	equ  0    ;(+/-);Offset polarity, for a negative offset put CVP = 1
;****************************************************************
ZSV  	equ  0   	;Zero suppression is off...Set this value to 1 for zero suppression.
;****************************************************************
			;ANNUNCIATOR:- [IRCN 0249]
			;Altering the two registers below will alter the 
			;annunciator displayed when in volts mode.

SYMBLA 	equ b'00100100'	;'A' segments (BAFCDEJO) for symbol/annunciator (1=on, 0=off)
SYMBLB	equ b'10000100'	;'B' segments (IHGNMLKR) for symbol/annunciator (1=on, 0=off)


; The following diagram will help in generating the desired character.
;			
;		       AAAAAAA
;    		      FG  H  IB	 
;  		      F G H I B  	 
;        	   R  F  GHI  B   	 
;  		       JJJ KKK       	 
; 		   R  E  LMN  C   	 
;		      E L M N C   	 
;  		      EL  M  NC  	 
;    		 O     DDDDDDD
;	  
;**************************************************************** 
			;Select the position of the decimal point
			;For no decimal point, select 0.
DPV 	equ  3		;1= 999.9V 
			;2= 99.99V 
			;3= 9.999V
;****************************************************************
			;digit position modifier
DPMV 	equ  1		;0=default position (LSD dig2)
			;1=position (LSD dig3)
;****************************************************************
RFV2 	equ  0		;The internal ADC reference voltage uses Vdd (+5.00v)
RFV3 	equ  0		;To use an external reference, insert the new reference voltage
RFV4 	equ  5		;in the range REF = 1.0 to 5.0
			;The external reference should be connected to porta,3
;****************************************************************
		    	;These numbers specify the HIGH WARNING level as 45 
WV3H   	equ  5    	;at which a warning message will be displayed 
WV4H   	equ  3    	;if the display exceeds this value.
WV5H   	equ  0	   	;Change these numbers to the required high warning level 
NVWH   	equ  1		;Change to 0 for no high warning
	
		    	;This number specifies the LOW WARNING level as 15 
WV3L  	equ  0    	;at which a warning message will be displayed if the
WV4L  	equ  1    	;display falls below this value. 
WV5L  	equ  0 		;Change these numbers to the required low warning level 
NVWL  	equ  1		;Change to 0 for no low warning
				 			
		    	;These numbers specify the HIGH ALARM level
AV3H  	equ  0    	;as 40 at which an alarm will be triggered
AV4H  	equ  4    	;if the display exceeds this value. 
AV5H  	equ  0    	;Change these numbers to the required high alarm level
NVAH  	equ  1		;Change to 0 for no high alarm

			;This number specifies the LOW ALARM level as 20	
AV3L  	equ  5    	;at which an alarm will be triggered if the display 
AV4L  	equ  0    	;falls below this value.
AV5L  	equ  0    	;Change these numbers to the required low alarm level
NVAL  	equ  1		;Change to 0 for no low alarm  		
;**************************************************************** 
		;DUE TO THE SIZE OF THE ADC THE MAXIMUMUM ACCURACY IS 1024 UNITS. 
		;IF MORE ACCURACY IS REQUIRED AN EXTERNAL ADC SHOULD BE FITTED.
		;SEE THE FILE FOR INTERFACING WITH EXTERNAL ADC'S.
;****************************************************************
DDV  	equ  35	;Display voltage refresh time...
		;Set between 25 and 45 
		;The larger the number the longer the period between readings.
DMV  	equ  35    ;Message display hold time...
		;Set between 25 and 45 
		;The larger the number the longer the message is displayed.	
;****************************************************************
;###### WARNING DO NOT EXCEED THE POWER SUPPLY VOLTAGE OF 5 VOLTS ON THE ANALOGUE INPUTS
;###### IF YOU WISH TO MEASURE VOLTAGE IN EXCESS OF THIS USE SCALING RESISTORS AND ADJUST
;###### THE 'VM' VALUE ACCORDINGLY!!!
;****************************************************************
;NOTE:		;This program uses the data message file <mess_1-5> to activate the
		;messages 'TooHI' 'TooLo' 'HIALA' and 'LoALA' if the alarms are set.
;****************************************************************
