; file      : volt_1-0.inc
; author    : 
; date      : 14-SEP-1999
; purpose   : Voltmeter Routine
; used by   : Library routine
;
; Copyright (C) Lascar Electronics Ltd 1999
;
; This library is free software; you can redistribute it and/or
; modify it under the terms of the GNU Lesser General Public
; License as published by the Free Software Foundation; either
; version 2.1 of the License, or (at your option) any later version.
;
; This library is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; Lesser General Public License for more details.

; You should have received a copy of the GNU Lesser General Public
; License along with this library; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
; USA
;
;
;**************************************************************
;
;This routine uses readings taken from porta,0 of the 16F877 PICmicro (R). 
;A/D conversion is done by the onchip 10bit A/D converter. The readings are stored
;in the adresh and adresl registers.

;***DISPLAY VOLT MESSAGE***

VOLT_PROG
	CALL	CLR_DISPS2
	BCF	rb0		;set
	BSF	rb1		;bank2
	MOVLW	24H		;w=vector for VOLTS
	MOVWF	EEP2		;EEP2 = VOLTS
	CALL	READ_MESSB	;Display message

;***STORE MODULE CONFIGURATION IN EEPROM***
;For voltmeter the value 00h is stored to address 0ffh

	BCF	rb0		;set
	BSF	rb1		;bank2
	MOVLW	0FFH		;W=0FFH 
	MOVWF	eeadr		;eeardr=0FFH
	MOVLW	00H		;W=00H
	MOVWF	eedata		;eedata=00H
	BSF	rp2		;page3
	CALL	WR_EEPROM	;read from EEPROM
	BCF	rp2		;page2		
	
;***ANALOGUE TO DIGITAL CONVERSION***

ADC_VOLTS
	BSF	adcon0,0	;Turn-on A/D
	BSF	rb0	    	;Select bank1
	BSF	adcon1,7	;set adfm result format justify right
	MOVLW	0FFH	 	;Set-up analogue all ,8 inputs as analogue
				;with Vdd and Vss as + & - references
	MOVWF	trisa		;RA0/AN0 (bank1)
	CLRF	status		;bank0
	MOVLW	b'01000001' 	;Fosc=RC/bit7=1/bit6=1;bits3,5=0 for RA0/AN0		
	MOVWF	adcon0		;select analogue input,start ADC,bank0	
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	BSF	adcon0,2	;Start conversion				
V_DONE	BTFSC	adcon0,2   	;Conversion finished?go/done=0
	GOTO	V_DONE	        ;No? Then continue
	BCF	adcon0,0	;Turn-off A/D

;***SET UP THE VOLTMETER PARAMETERS***

DVMR	BCF	NEGF1		;Clear the
	BCF	NEGF2		;negative flags
;Display=[RefxADC/1024][(FSV-CV)/MV]+CV
;where 'FSV' is the displayed value at input voltage 'V',
;and 1024 is the ADC accuracy.
;and 'CV' is the offset
;
;Get the 'FSR' values and place in the BCD1\2\3\4 registers
;NOTE: The 'FSR' & 'C' values are shifted (x) 10 to allow for dec'V'...
;and convert to binary code for maths subroutines...
	CLRF	BCD1		;Clear BCD1
	MOVLW	FSV2		;Get value in 'FSV2' 
	MOVWF	BCD2		;Place in BCD2
	MOVLW	FSV3		;Get value in 'FSV3'
	MOVWF	BCD3		;Place in BCD3
	MOVLW	FSV4		;Get value in 'FSV4'
	MOVWF	BCD4		;Place in BCD4
	MOVLW	FSV5		;Get value in 'FSV5'
	MOVWF	BCD5		;Place in BCD5
	BSF	rp2		;page3
	CALL	BCD_BINARY	;convert <math_1-5.inc>
;These values are returned in ACC1\2\3	
;
;Prepare to multiply the FSR figure by the Ref value...
;Transfer these to the SUB1L\H	registers for subtraction by the offset...
	MOVF	ACC1,w		;w=ACC1
	MOVWF	SUB1L		;SUB1L=ACC1	 
	MOVF	ACC2,w		;w=ACC2
	MOVWF	SUB1H		;SUB1H=ACC2
;Get the 'C' values and place in the BCD registers
	CLRF	BCD1		;Clear BCD1
	MOVLW	CV2		;Get value in 'CV2' 
	MOVWF	BCD2		;Place in BCD2
	MOVLW	CV3		;Get value in 'CV3'
	MOVWF	BCD3		;Place in BCD3
	MOVLW	CV4		;Get value in 'CV4'
	MOVWF	BCD4		;Place in BCD4
	CLRF	BCD5		;Clear BCD4
	CALL	BCD_BINARY	;convert <math_1-5.inc>
;These values are returned in ACC1\2\3
;Transfer these to the SUB2L\H	registers for subtraction from the FSR...
	MOVF	ACC1,w		;w=ACC1
	MOVWF	SUB2L		;SUB2L=ACC1	 
	MOVF	ACC2,w		;w=ACC2
	MOVWF	SUB2H		;SUB2H=ACC2
	MOVF	CVP,w		;Get offset polarity
	BTFSS	zero		;If zero add offset,
	BSF	NEGF2		;else subtract
        CALL    ADDITION        ;(FSV+CV)
;These values are returned in ACC1\2\3
;Move these values into the MCND registers for Multiplication by Ref...
	MOVF	ACC1,w		;w=ACC1
	MOVWF	MCNDL		;DVD1=ACC1
 	MOVF	ACC2,w		;w=ACC2
	MOVWF	MCNDH		;DVD2=ACC
;Get the 'Ref' value and place in the BCD registers	 
	MOVLW	RFV2		;Get value in 'RFV2' 
	MOVWF	BCD1		;Place in BCD1
	MOVLW	RFV3		;Get value in 'RFV3'
	MOVWF	BCD2		;Place in BCD2
	MOVLW	RFV4		;Get value in 'RFV4'
	MOVWF	BCD3		;Place in BCD3
	CLRF	BCD4		;Clear BCD4
	CLRF	BCD5		;Clear MSD
	CALL	BCD_BINARY	;convert <math_1-5.inc>
;These values are returned in ACC1\2\3
;Move the 'Ref' value into the MPLR registers to multiply (FSV-CV)
	MOVF	ACC1,w		;w=ACC1
	MOVWF	MPLRL		;MPLRL=ACC1	 
	MOVF	ACC2,w		;w=ACC2
	MOVWF	MPLRH		;MPLRH=ACC2
	CALL	MULTIPLICATION	;REF(FSR-CV) <math_1-5.inc>
;Product returned in ACC1\2\3
;Move this product into the dividend registers for dividing by 'V'
	MOVF	ACC1,w		;w=ACC1
	MOVWF	DVD1		;DVD1=ACC1
 	MOVF	ACC2,w		;w=ACC2
	MOVWF	DVD2		;DVD2=ACC2
	MOVF	ACC3,w		;w=ACC3
	MOVWF	DVD3		;DVD3=ACC3
;Get the 'V'values and place in the BCD1\2\3 registers
	CLRF	BCD1		;Place in BCD1
	MOVLW	MV2		;Get value in 'V2' 
	MOVWF	BCD2		;Place in BCD2
	MOVLW	MV3		;Get value in 'V3' 
	MOVWF	BCD3		;Place in BCD3
	CLRF	BCD4		;Clear BCD4
	CLRF	BCD5		;Clear BCD5
	CALL	BCD_BINARY	;convert <math_1-5.inc>
;These values are returned in ACC1\2\3
;Move these values to the Divisor registers to divide REF(FSV-C)
	MOVF	ACC1,w		;w=ACC1
	MOVWF	DVRL		;DVD1=ACC1
 	MOVF	ACC2,w		;w=ACC2
	MOVWF	DVRH		;DVD2=ACC2
	CALL	DIVISION	;REF(FSV-C)/V <math_1-5.inc>
;This quotient is returned in ACC1\2\3
;Place these in the multiplicand registers for mult.by ADC
	MOVF	ACC1,w		;w=AC1
	MOVWF	MCNDL		;MCNDL=ACC1	 
	MOVF	ACC2,w		;w=ACC2
	MOVWF	MCNDH		;MCNDH=ACC2
;Now fetch the result of the ADC conversion and place in the
;multiplier registers to multiply REF(FSR-C)/V... 
	BSF	rb0		;bank1
	MOVF	adresl,w	;w=adresl
	BCF	rb0		;bank0
	MOVWF	MPLRL		;MPLRL=adresl	 
	MOVF	adresh,w	;w=adresh
	MOVWF	MPLRH		;MPLRH=adresh
	CALL	MULTIPLICATION	;ADCxREF(FSV-C)/V <math_1-5.inc>
;This product is returned in ACC1\2\3
;Move these values to the Dividend registers to be divided by
;the ADC accuracy 1024bits
	MOVF	ACC1,w		;w=ACC1
	MOVWF	DVD1		;DVD1=ACC1	 
	MOVF	ACC2,w		;w=ACC2
	MOVWF	DVD2		;DVD2=ACC2
	MOVF	ACC3,w		;w=ACC3
	MOVWF	DVD3		;DVD3=ACC3
;Move dec1024 into the divisor registers...
	CLRF	DVRL		;DVRL=0H
	MOVLW	00H		;w=00H		;Divide by
	MOVWF	DVRL		;DVRL=00H	;decimal
	MOVLW	04H		;w=04H		;1024
	MOVWF	DVRH		;DVRH	
	CALL	DIVISION	;[ADCxREF(FSV-C)/V]/1024
	BCF	rp2		;page2
;The quotient is returned in ACC1\2\3...
;Move these to the byte1 sum registers for addition of the offset...
	MOVF	ACC1,w		;w=ACC1
	MOVWF	ADD1L		;ADD1L=ACC1
	MOVF	ACC2,w		;w=ACC2
	MOVWF	ADD1H		;ADD1H=ACC2
;Get the 'C' values and place in the BCD registers
	CLRF	BCD1		;Clear BCD1
	MOVLW	CV2		;Get value in 'CV2' 
	MOVWF	BCD2		;Place in BCD2
	MOVLW	CV3		;Get value in 'CV3'
	MOVWF	BCD3		;Place in BCD3
	MOVLW	CV4		;Get value in 'CV4'
	MOVWF	BCD4		;Place in BCD4
	CLRF	BCD5		;Clear BCD4
;Test for 4-20mA loop, is RD6 Hi?
	BTFSS	portd,6		;4-20mA loop?
	GOTO	ADDV3		;skip this routine
	MOVLW	04H		;4mA/100ohms
	MOVWF	BCD2		;BCD=40
	CLRF	BCD1		;clear registers
	CLRF	BCD3		;clear
	CLRF	BCD4		;clear
	CLRF	BCD5		;clear
;
ADDV3	BSF	rp2		;page3
	CALL	BCD_BINARY	;convert <math_1-5.inc>
;These values are returned in the ACC1\2\3 registers...
;Move these values to the byte2 sum registers to add to [ADCxREF(FSV-C)/V]/1024	
	MOVF	ACC1,w		;w=ACC1
	MOVWF	ADD2L		;ADD2L=ACC1
	MOVF	ACC2,w		;w=ACC2
	MOVWF	ADD2H		;ADD2H=ACC2
	MOVF	CVP,w		;Get offset polarity
	BTFSS	zero		;If zero add offset,
	BSF	NEGF2		;else subtract
        CALL    ADDITION        ;{[ADCxREF(FSV-C)/V]/1024}+C
;These values are returned in the ACC1\2\3 registers...
;Now reconnvert to BCD...
	CALL	BINARY_BCD	;End of maths routines...
	BCF	rp2		;page2
;Converts Binary to Binary coded decimal.
;BCD code returned in registers BCD1\2\3\4\5
;
	BTFSC	portd,0		;Is message pin28 Hi?				
	GOTO	DISPLAY_V	;No? Then skip message routines
				;Yes? Then test for warning/alarm values...
	MOVLW	DMV		;Get message
	MOVWF	DS_DEL		;display time.	

;***TEST FOR ALARMS AND WARNINGS***
;The values of the alarm and warning levels can be set in <volt_1-0.h>

HIV_ALARM
	BCF	zero
	MOVLW	NVAH		;No Hi-ALARM?
	BTFSC	zero		;If zero then skip this ALARM
	GOTO	HIV_warning	;to...	
	MOVLW	AV5H		;Get digit5 Hi-ALARM value
	SUBWF	BCD5,w		;actual-warning
	BTFSC	zero		;Test for =,if= then test AT4H 
	GOTO	AV4H1		;Check next bytes
	BTFSC	carry		;Test for -ve answer
	GOTO	HIV_A
	GOTO	HIV_warning
AV4H1	MOVLW	AV4H		;Get digit4 Hi-ALARM value
	SUBWF	BCD4,w		;actual-warning
	BTFSC	zero		;Test for =,if= then test AT3H 
	GOTO	AV3H1		;Check next bytes
	BTFSC	carry		;Test for -ve answer
	GOTO	HIV_A
	GOTO	HIV_warning
AV3H1	MOVLW	AV3H		;Get digit3 Hi-ALARM value
	SUBWF	BCD3,w		;actual-warning
	BTFSC	carry		;if -ve, then no carry
	GOTO	HIV_A		;Then display HI-ALM

HIV_warning
	BCF	zero
	MOVLW	NVWH		;No Hi-warning?
	BTFSC	zero		;If zero then skip this warning
	GOTO	LoV_ALARM	;to...	
	MOVLW	WV5H		;Get digit5 HI-warning value
	SUBWF	BCD5,w		;actual-warning
	BTFSC	zero		;Test for =,if= then test WT4H 
	GOTO	WV4H1		;Check next bytes
	BTFSC	carry		;Test for -ve answer
	GOTO	HIV_W
	GOTO	LoV_ALARM
WV4H1	MOVLW	WV4H		;Get digit4 HI-warning value
	SUBWF	BCD4,w		;actual-warning
	BTFSC	zero		;Test for =,if= then test WT3H 
	GOTO	WV3H1		;Check next bytes
	BTFSC	carry		;Test for -ve answer
	GOTO	HIV_W
	GOTO	LoV_ALARM
WV3H1	MOVLW	WV3H		;Get digit3 HI-warning value
	SUBWF	BCD3,w		;actual-warning
	BTFSC	carry		;if -ve, then no carry
	GOTO	HIV_W		;Then display Too-HI

LoV_ALARM
	BCF	zero
	MOVLW	NVAL		;No Lo-ALARM?
	BTFSC	zero		;If zero then skip this ALARM
	GOTO	LoV_warning	;Display voltage	
	MOVLW	AV5L		;Get digit5 Lo-ALARM value
	SUBWF	BCD5,w		;actual-warning
	BTFSC	zero		;Test for =,if= then test AT4H 
	GOTO	AV4L1		;Check next bytes
	BTFSS	carry		;Test for -ve answer
	GOTO	LoV_A
	GOTO	LoV_warning
AV4L1	MOVLW	AV4L		;Get digit4 Lo-ALARM value
	SUBWF	BCD4,w		;actual-warning
	BTFSC	zero		;Test for =,if= then test AT3H 
	GOTO	AV3L1		;Check next bytes
	BTFSS	carry		;Test for -ve answer
	GOTO	LoV_A
	GOTO	LoV_warning
AV3L1	MOVLW	AV3L		;Get digit3 Lo-ALARM value
	SUBWF	BCD3,w		;actual-warning
	BTFSS	carry		;if -ve, then no carry
	GOTO	LoV_A		;Then display LO-ALM	

LoV_warning
	BCF	zero
	MOVLW	NVWL		;No Lo-warning?
	BTFSC	zero		;If zero then skip this warning
	GOTO	DISPLAY_V	;to...		
	MOVLW	WV5L		;Get digit5 LO-warning value
	SUBWF	BCD5,w		;actual-warning
	BTFSC	zero		;Test for =,if= then test WT4L 
	GOTO	WV4L1		;Check next bytes
	BTFSS	carry		;Test for -ve answer
	GOTO	LoV_W
	GOTO	DISPLAY_V
WV4L1	MOVLW	WV4L		;Get digit4 Lo-warning value
	SUBWF	BCD4,w		;actual-warning
	BTFSC	zero		;Test for =,if= then test WT3L 
	GOTO	WV3L1		;Check next bytes
	BTFSS	carry		;Test for -ve answer
	GOTO	LoV_W
	GOTO	DISPLAY_V
WV3L1	MOVLW	WV3L		;Get digit3 LO-warning value
	SUBWF	BCD3,w		;actual-warning
	BTFSS	carry		;if -ve, then no carry
	GOTO	LoV_W		;Then display Too-LO
	GOTO	DISPLAY_V

HIV_W	CALL	TOO_HI		;<mess_1-5.inc>
	GOTO	DISPLAY_V	;Display voltage
LoV_W	CALL	TOO_LO		;<mess_1-5.inc>
	GOTO	DISPLAY_V	;Display voltage
HIV_A	CALL	HI_ALM		;<mess_1-5.inc>
	GOTO	DISPLAY_V	;Display voltage	
LoV_A	CALL	LO_ALM		;<mess_1-5.inc>
	GOTO	DISPLAY_V	;Display voltage

;***CHECK FOR THE DECIMAL POINT POSITION (PINS)***

DP_POSV	BTFSC	portd,2		;Is portd,2 high?
	GOTO	DP_P0V		;Yes, is portd,3 high aswell?
	BTFSC	portd,3		;No, s only portd,3 high?
	GOTO	DP_P3V		;Yes, goto DP_P3V
	GOTO	DP_HDRV		;No, what about header
DP_P0V	BTFSC	portd,3		;Is portd,3 high aswell?
	GOTO	DP_P2V		;Yes, put dp in digit 4
DP_P1V	BSF	SHIFT2,0	;No, put dp in digit 2
	GOTO	DISPV1
DP_P2V	BSF	SHIFT3,0	;Put dp in digit 3 
	GOTO	DISPV1
DP_P3V	BSF	SHIFT4,0	;Put dp in digit 4
	GOTO	DISPV1

;***CHECK FOR THE DECIMAL POINT POSITION (HEADER)***

DP_HDRV	MOVLW	DPV		;d.p. header specified position
	ADDWF	pcl,f
	GOTO	DISPV1		;No decimal point
	GOTO	DP_P1V		;999.9V
	GOTO	DP_P2V		;99.99V	
	GOTO	DP_P3V		;9.999V

;***CHECK FOR DIGIT POSITION (PINS)***

DIGIT_POSV
	BTFSS	portd,4		;check portd,4
	GOTO	DIG_POS_HDR	;check header 
	MOVLW	DPMV		;add one to
	MOVWF	DPM		;shift the digit
	RETURN			;position

;***CHECK FOR DIGIT POSITION (HEADER)***

DIG_POS_HDR
	BTFSS	DPMV,0
	RETURN			;default digit position (LSD dig2)
	MOVLW	DPMV		;add one to
	MOVWF	DPM		;shift the digit
	RETURN			;position (LSD to dig3)

;***NOW DISPLAY THE RESULTS <ltdd_1-0.inc>***

DISPLAY_V
	MOVLW	01H		;Set digit position modifier
	MOVWF	DPM		;to shift the units position.
	BCF	B_SEGS		;Clear B_SEGS flag
;NUM_SEGS gets the values from the 'BCD' registers and transfers them 
;to the 'SHIFT' registers to build the 43 bit display word...
	BSF	rp2		;page3
	CALL 	NUM_SEGS	;Fetch display segments 'A'
	BCF	rp2		;page2
	BSF	pclath,0
	GOTO	DP_POSV		;check for decimal point position
DISPV1	CALL	DIGIT_POSV	;check for digit position
	BCF	pclath,0
	MOVLW	SYMBLA		;Annunciator - can be changed in header [IRCN 0249]
	MOVWF	SHIFT1		;Display in digit position 1a
	CLRF	SHIFTX		;COM1
	BSF	rp2		;page3
	CALL	ASSEMBLE	;Assemble 43 bit 'A' word
	BSF	B_SEGS		;set LUT 'B' flag
	CALL 	NUM_SEGS	;Fetch display segments 'B'
	MOVLW	SYMBLB		;Annunciator - can be changed in header [IRCN 0249]
	MOVWF	SHIFT1		;Display in digit position 1b
	MOVLW	020H		;COM2
	MOVWF	SHIFTX		;bit
	CALL	ASSEMBLE	;Assemble 43 bit 'B' word
	CLRF	DPM		;Clear digit position modifier
	CALL	LED_OFF		;Program active indicator
	MOVLW	DDV		;Get message
	MOVWF	DS_DEL		;display time.
	CALL	DELAY		;Off for this period
	CALL	LED_ON		;Program active indicator
	BCF	rp2		;page2
	GOTO	ADC_VOLTS	;for next ADC conversion...
;
;*****************************************************************************




