//
// file      : oem4_demo.c
// author    : Ian Forse
// date      : 24-AUG-2004
// purpose   : Demonstration of OEM4-LED Display modes
// includes  : None
// notes     : 
//
// Copyright (C) 2004 Lascar Electronics Ltd
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.

// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
// USA

// ----------------------------------------------------------------------------
// Blink All Segments
// ----------------------------------------------------------------------------

unsigned char START_AND_LED;

void blink (void)
{
	signed char i;
	for (i=2; i>=0; i--)
	{
		START_AND_LED = 0xFF;
		oem4_all( 0xFF );
		DelayMs(250);
		START_AND_LED = 0x00;
		oem4_all( 0x00 );
		DelayMs(250);
	}
}


// ----------------------------------------------------------------------------
// Display 12.34 by writing to individual positions
// ----------------------------------------------------------------------------

void show_1234 (void)
{     
	oem4_clear();
	oem4_write_p( 1, LET_1 );
	oem4_write_p (2,'.');
	oem4_write_p( 2, LET_2 );
	oem4_write_p( 3, LET_3 );
	oem4_write_p( 4, LET_4 );
	DelayMs(250);
	DelayMs(250);
	DelayMs(250);
	DelayMs(250);
}


// ----------------------------------------------------------------------------
// Show all characters
// ----------------------------------------------------------------------------

void show_ascii (void)
{
	unsigned char n = 0;
	while(1)
	{
		oem4_write_p( 1, (( n / 10 ) % 10 ) );
		oem4_write_p( 2, ( n % 10 ) );
		oem4_write_p( 3, LET_minus );                 
		oem4_write_p( 4, n );                 
		DelayMs(250);
		n++;
		if (n == 0x18) break; //{
	}
}              
                 
                 
// ----------------------------------------------------------------------------
// Show a scrolling message by writing TTY-wise and rotating
// ----------------------------------------------------------------------------

 
void write( char c )
{
	oem4_write( c );
	DelayMs(250);
}


void show_LASCAr (void)
{  
	signed char i;   
	oem4_clear();
	oem4_cursor_position = 4;
	for (i=2; i>=0; i--)
	{
		write( LET_L );
		write( LET_A );
		write( LET_S );
		write( LET_C );
		write( LET_A );
		write( LET_r );
		write( LET_SP );
	}
}

// ----------------------------------------------------------------------------
// Blank Display for 1 second
// ----------------------------------------------------------------------------

void blank (void)
{
	START_AND_LED = 0x00;
	oem4_all( 0 );
	DelayMs(250);
	DelayMs(250);
	DelayMs(250);
	DelayMs(250);
}
