//
// file      : oem4_drv.c
// author    : Ian Forse
// date      : 24-AUG-2004
// purpose   : Analogue read and display on OEM4-LED
// includes  : pic.h, adc.c, delay.h, delay.c, oem4.c, oem4.h oem4_demo.c
// notes     : Includes display demo mode switchable via RD7.
//
// Copyright (C) 2004 Lascar Electronics Ltd
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.

// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
// USA

#include <pic.h>
__CONFIG (3F72h);
#include "adc.c"
#include "delay.h"
#include "delay.c"
#include "oem4.c"
#include "oem4.h"
#include "oem4_demo.c"

main()
{
TRISD7 = 1;
adc_init();
oem4_init();
oem4_all(0);

	while(1)
	{
		if (RD7 == 0)
		{
			unsigned int ADC_DATA, CHANNEL;
			CHANNEL = 0;
			ADC_DATA = ReadADC (CHANNEL);
			oem4_write_p (1,'.');
			oem4_write_p (1,((ADC_DATA >>  12) & 0x000f));
			oem4_write_p (2,((ADC_DATA >>   8) & 0x000f));
			oem4_write_p (3,((ADC_DATA >>   4) & 0x000f));
			oem4_write_p (4,((ADC_DATA >>   0) & 0x000f));
			DelayMs(250);
		}
		else
		{
			blink();
			blank();
			show_1234();
			blank();    
			show_ascii(); 
			blank();
			show_LASCAr();
			blank();
		}
	}
}
